/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.ChunkLocale;
import com.x5.template.LocaleTag;
import com.x5.template.Snippet;
import com.x5.template.SnippetPart;
import java.io.IOException;
import java.io.Writer;

public class SnippetToken
extends SnippetPart {
    protected String token;
    private String[] args;

    public SnippetToken(String text, String token) {
        super(text);
        this.token = token;
    }

    public void render(Writer out, Chunk context, String origin, int depth) throws IOException {
        ChunkLocale locale = context.getLocale();
        String translated = null;
        if (locale == null) {
            if (this.args == null) {
                out.append(this.token);
                return;
            }
            translated = ChunkLocale.processFormatString(this.token, this.args, context);
        } else {
            translated = locale.translate(this.token, this.args, context);
        }
        Snippet reprocess = Snippet.getSnippet(translated);
        reprocess.render(out, context, depth);
    }

    public static SnippetToken parseTokenWithArgs(String wholeTag) {
        int bodyA = 3;
        int bodyB = wholeTag.lastIndexOf(LocaleTag.LOCALE_SIMPLE_CLOSE);
        if (bodyB < 0) {
            return new SnippetToken(wholeTag, wholeTag.substring(bodyA));
        }
        int argsA = bodyB + 1;
        int argsB = wholeTag.length();
        if (wholeTag.endsWith(LocaleTag.LOCALE_TAG_CLOSE)) {
            --argsB;
        }
        if (wholeTag.startsWith("{%")) {
            ++bodyA;
            while (Character.isWhitespace(wholeTag.charAt(bodyA - 2))) {
                ++bodyA;
            }
            if (wholeTag.charAt(argsB - 1) == '%') {
                --argsB;
            }
            while (Character.isWhitespace(wholeTag.charAt(argsB - 1))) {
                --argsB;
            }
        }
        if (wholeTag.charAt(argsA) == ',') {
            ++argsA;
        }
        String params = wholeTag.substring(argsA, argsB);
        String body = wholeTag.substring(bodyA, bodyB);
        SnippetToken tokenWithArgs = new SnippetToken(wholeTag, body);
        if (params != null && params.trim().length() > 0) {
            String[] args = params.split(" *, *");
            tokenWithArgs.args = args;
        }
        return tokenWithArgs;
    }
}

