/*
 * Decompiled with CFR 0.152.
 */
package com.x5.util;

import com.madrobot.beans.BeanInfo;
import com.madrobot.beans.Introspector;
import com.x5.util.DataCapsule;
import com.x5.util.DataCapsuleReader;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDataMap
implements Map {
    private Map<String, Object> pickle = null;
    private Object object;
    private boolean isBean = false;
    private static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();
    private static final HashSet<Class<?>> WRAPPER_TYPES = ObjectDataMap.getWrapperTypes();
    private static final Class[] NO_ARGS = new Class[0];
    private static Map<Class, Boolean> hasOwnToString = new HashMap<Class, Boolean>();
    private static Map<Class, Field[]> declaredFields = new HashMap<Class, Field[]>();
    private static Map<String, String> snakeCased = new HashMap<String, String>();

    private static HashSet<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        return ret;
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    public ObjectDataMap(Object pojo) {
        this.object = pojo;
    }

    private void init() {
        if (this.pickle == null) {
            this.pickle = this.mapify(this.object);
            if (this.pickle == null) {
                this.pickle = EMPTY_MAP;
            }
        }
    }

    public static ObjectDataMap wrapBean(Object bean) {
        if (bean == null) {
            return null;
        }
        ObjectDataMap boxedBean = new ObjectDataMap(bean);
        boxedBean.isBean = true;
        return boxedBean;
    }

    public static String getAsString(Object obj) {
        Class<?> objClass = obj.getClass();
        Boolean doStringify = hasOwnToString.get(objClass);
        if (doStringify == null) {
            Method toString = null;
            try {
                toString = obj.getClass().getMethod("toString", NO_ARGS);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            doStringify = new Boolean(toString != null && !toString.getDeclaringClass().equals(Object.class));
            hasOwnToString.put(objClass, doStringify);
        }
        if (doStringify.booleanValue()) {
            return obj.toString();
        }
        return "OBJECT:" + obj.getClass().getName();
    }

    private Map<String, Object> mapify(Object pojo) {
        Map<String, Object> data = null;
        if (pojo instanceof DataCapsule) {
            return this.mapifyCapsule((DataCapsule)pojo);
        }
        if (!this.isBean) {
            data = this.mapifyPOJO(pojo);
            if (data == null || data.isEmpty()) {
                this.isBean = true;
            } else {
                return data;
            }
        }
        if (this.isBean) {
            try {
                try {
                    Class<?> beanClass = Class.forName("java.beans.Introspector");
                    return StandardIntrospector.mapifyBean(pojo);
                }
                catch (ClassNotFoundException e) {
                    try {
                        Class<?> madrobotClass = Class.forName("com.madrobot.beans.Introspector");
                        return MadRobotIntrospector.mapifyBean(pojo);
                    }
                    catch (ClassNotFoundException e2) {
                    }
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return data;
    }

    public Map<String, Object> mapifyPOJO(Object pojo) {
        Field[] fields = null;
        Class<?> pojoClass = pojo.getClass();
        if (declaredFields.containsKey(pojoClass)) {
            fields = declaredFields.get(pojoClass);
        } else {
            fields = pojoClass.getDeclaredFields();
            declaredFields.put(pojoClass, fields);
        }
        HashMap<String, Object> pickle = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String paramName = field.getName();
            Class<?> paramClass = field.getType();
            int mods = field.getModifiers();
            if (!Modifier.isPrivate(mods) && !Modifier.isProtected(mods)) {
                field.setAccessible(true);
            }
            Object paramValue = null;
            try {
                paramValue = field.get(pojo);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (pickle == null) {
                pickle = new HashMap<String, Object>();
            }
            paramName = ObjectDataMap.splitCamelCase(paramName);
            ObjectDataMap.storeValue(pickle, paramClass, paramName, paramValue, this.isBean);
        }
        return pickle;
    }

    private Map<String, Object> mapifyCapsule(DataCapsule capsule) {
        DataCapsuleReader reader = DataCapsuleReader.getReader(capsule);
        String[] tags = reader.getColumnLabels(null);
        Object[] data = reader.extractData(capsule);
        this.pickle = new HashMap<String, Object>();
        for (int i = 0; i < tags.length; ++i) {
            Object val = data[i];
            if (val == null) continue;
            if (val instanceof String) {
                this.pickle.put(tags[i], val);
                continue;
            }
            if (val instanceof DataCapsule) {
                this.pickle.put(tags[i], new ObjectDataMap(val));
                continue;
            }
            this.pickle.put(tags[i], val.toString());
        }
        return this.pickle;
    }

    private static void storeValue(Map<String, Object> pickle, Class paramClass, String paramName, Object paramValue, boolean isBean) {
        if (paramValue == null) {
            pickle.put(paramName, null);
        } else if (paramClass == String.class) {
            pickle.put(paramName, paramValue);
        } else if (paramClass.isArray() || paramValue instanceof List) {
            pickle.put(paramName, paramValue);
        } else if (paramValue instanceof Boolean) {
            if (((Boolean)paramValue).booleanValue()) {
                pickle.put(paramName, "TRUE");
            }
        } else if (paramClass.isPrimitive() || ObjectDataMap.isWrapperType(paramClass)) {
            pickle.put(paramName, paramValue);
        } else {
            ObjectDataMap boxedParam = isBean ? ObjectDataMap.wrapBean(paramValue) : new ObjectDataMap(paramValue);
            pickle.put(paramName, boxedParam);
        }
    }

    public static String splitCamelCase(String s) {
        int i;
        String cached = snakeCased.get(s);
        if (cached != null) {
            return cached;
        }
        StringBuilder snakeCase = new StringBuilder();
        int m = 0;
        char[] chars = s.toCharArray();
        char[] lower = new char[chars.length];
        for (i = 0; i < chars.length; ++i) {
            char c = chars[i];
            lower[i] = c >= 'A' && c <= 'Z' ? (char)(c + 32) : c;
        }
        for (i = 1; i < chars.length; ++i) {
            char c0 = chars[i - 1];
            char c1 = chars[i];
            if (c0 < 'A' || c0 > 'Z') {
                if (c1 < 'A' || c1 > 'Z') continue;
                snakeCase.append(lower, m, i - m);
                snakeCase.append('_');
                m = i;
                continue;
            }
            if (i - m <= 1 || c0 < 'A' || c0 > 'Z' || c1 <= 'Z' && c1 >= 'A') continue;
            snakeCase.append(lower, m, i - 1 - m);
            snakeCase.append('_');
            m = i - 1;
        }
        snakeCase.append(lower, m, lower.length - m);
        cached = snakeCase.toString();
        snakeCased.put(s, cached);
        return cached;
    }

    @Override
    public int size() {
        this.init();
        return this.pickle.size();
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.pickle.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.init();
        return this.pickle.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.init();
        return this.pickle.containsValue(value);
    }

    public Object get(Object key) {
        this.init();
        return this.pickle.get(key);
    }

    public Object put(Object key, Object value) {
        return null;
    }

    public Object remove(Object key) {
        return null;
    }

    public void putAll(Map m) {
    }

    @Override
    public void clear() {
    }

    public Set keySet() {
        this.init();
        return this.pickle.keySet();
    }

    public Collection values() {
        this.init();
        return this.pickle.values();
    }

    public Set entrySet() {
        this.init();
        return this.pickle.entrySet();
    }

    public String toString() {
        return ObjectDataMap.getAsString(this.object);
    }

    public Object unwrap() {
        return this.object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MadRobotIntrospector {
        private MadRobotIntrospector() {
        }

        private static Map<String, Object> mapifyBean(Object bean) throws IntrospectionException {
            com.madrobot.beans.PropertyDescriptor[] properties = null;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
                properties = beanInfo.getPropertyDescriptors();
            }
            catch (com.madrobot.beans.IntrospectionException e) {
                throw new IntrospectionException();
            }
            if (properties == null) {
                return null;
            }
            HashMap pickle = null;
            for (com.madrobot.beans.PropertyDescriptor property : properties) {
                Class paramClass = property.getPropertyType();
                Method getter = property.getReadMethod();
                try {
                    Object paramValue = getter.invoke(bean, (Object[])null);
                    if (paramValue == null) continue;
                    String paramName = property.getName();
                    paramName = ObjectDataMap.splitCamelCase(paramName);
                    if (paramValue instanceof Boolean) {
                        paramName = "is_" + paramName;
                    }
                    if (pickle == null) {
                        pickle = new HashMap();
                    }
                    ObjectDataMap.storeValue(pickle, paramClass, paramName, paramValue, true);
                }
                catch (InvocationTargetException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            return pickle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandardIntrospector {
        private StandardIntrospector() {
        }

        private static Map<String, Object> mapifyBean(Object bean) throws IntrospectionException {
            PropertyDescriptor[] properties = null;
            try {
                java.beans.BeanInfo beanInfo = java.beans.Introspector.getBeanInfo(bean.getClass());
                properties = beanInfo.getPropertyDescriptors();
            }
            catch (java.beans.IntrospectionException e) {
                throw new IntrospectionException();
            }
            if (properties == null) {
                return null;
            }
            HashMap pickle = null;
            for (PropertyDescriptor property : properties) {
                Class<?> paramClass = property.getPropertyType();
                Method getter = property.getReadMethod();
                try {
                    Object paramValue = getter.invoke(bean, (Object[])null);
                    if (paramValue == null) continue;
                    String paramName = property.getName();
                    paramName = ObjectDataMap.splitCamelCase(paramName);
                    if (paramValue instanceof Boolean) {
                        paramName = "is_" + paramName;
                    }
                    if (pickle == null) {
                        pickle = new HashMap();
                    }
                    ObjectDataMap.storeValue(pickle, paramClass, paramName, paramValue, true);
                }
                catch (InvocationTargetException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            return pickle;
        }
    }

    private static class IntrospectionException
    extends Exception {
        private static final long serialVersionUID = 8890979383599687484L;

        private IntrospectionException() {
        }
    }
}

