/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.Snippet;
import com.x5.template.SnippetComment;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import com.x5.template.filters.RegexFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfTag
extends BlockTag {
    private String primaryCond;
    private Snippet body;
    private boolean doTrim = true;
    private Map<String, String> options;
    private static final Pattern UNIVERSAL_LF = Pattern.compile("\n|\r\n|\r\r");

    public IfTag(String params, Snippet body) {
        this.parseParams(params);
        this.initBody(body);
    }

    public IfTag() {
    }

    @Override
    public String getBlockStartMarker() {
        return "if";
    }

    @Override
    public String getBlockEndMarker() {
        return "/if";
    }

    private void initBody(Snippet body) {
        this.body = body;
    }

    private void parseParams(String params) {
        String cond;
        this.primaryCond = cond = this.parseCond(params);
        this.options = this.parseAttributes(params);
        if (this.options == null) {
            return;
        }
        String trimOpt = this.options.get("trim");
        if (trimOpt != null && (trimOpt.equalsIgnoreCase("false") || trimOpt.equalsIgnoreCase("none"))) {
            this.doTrim = false;
        }
    }

    private String parseCond(String params) {
        if (params == null) {
            return null;
        }
        int openParenPos = params.indexOf("(");
        int quotedCondPos = params.indexOf(" cond=\"");
        if (openParenPos > -1) {
            int closeParenPos = params.lastIndexOf(")");
            if (quotedCondPos < 0 && closeParenPos > openParenPos) {
                String test = params.substring(openParenPos + 1, closeParenPos);
                return test;
            }
        }
        if (quotedCondPos > -1) {
            int closeQuotePos = params.indexOf("\"", quotedCondPos += " cond='".length());
            if (closeQuotePos < 0) {
                return params.substring(quotedCondPos);
            }
            return params.substring(quotedCondPos, closeQuotePos);
        }
        return null;
    }

    private Map<String, String> parseAttributes(String params) {
        Pattern p = Pattern.compile(" ([a-zA-Z0-9_-]+)=(\"([^\"]*)\"|'([^']*)')");
        Matcher m = p.matcher(params);
        HashMap<String, String> opts = null;
        while (m.find()) {
            m.group(0);
            String paramName = m.group(1);
            String paramValue = m.group(3);
            if (opts == null) {
                opts = new HashMap<String, String>();
            }
            opts.put(paramName, paramValue);
        }
        return opts;
    }

    private boolean isTrueExpr(String test, Chunk context) {
        String[] parts;
        if (test == null) {
            return false;
        }
        if ((test = test.trim()).length() == 0) {
            return false;
        }
        char firstChar = test.charAt(0);
        if (firstChar == '!' || firstChar == '~' || firstChar == '$') {
            test = test.substring(1);
        }
        if (firstChar == '!' && (test.charAt(0) == '~' || test.charAt(0) == '$')) {
            test = test.substring(1);
        }
        if (test.indexOf(61) < 0 && test.indexOf("!~") < 0) {
            Object tagValue = context.get(test);
            if (firstChar == '~' || firstChar == '$') {
                return tagValue != null;
            }
            if (firstChar == '!') {
                return tagValue == null;
            }
            return test.equalsIgnoreCase("true");
        }
        boolean isNeg = false;
        if ((test.indexOf("==") > 0 || (isNeg = test.indexOf("!=") > 0)) && (parts = test.split("!=|==")).length == 2) {
            String tagValueA;
            String tagA = parts[0].trim();
            String tagB = parts[1].trim();
            Object tagValue = context.get(tagA);
            String string = tagValueA = tagValue == null ? "" : tagValue.toString();
            if (tagB.charAt(0) == '~' || tagB.charAt(0) == '$') {
                String tagValueB;
                tagValue = context.get(tagB.substring(1));
                String string2 = tagValueB = tagValue == null ? "" : tagValue.toString();
                if (isNeg) {
                    return !tagValueA.equals(tagValueB);
                }
                return tagValueA.equals(tagValueB);
            }
            String match = tagB;
            if (tagB.charAt(0) == '\"' && tagB.charAt(match.length() - 1) == '\"') {
                match = tagB.substring(1, tagB.length() - 1);
                match = this.unescape(match);
            } else if (tagB.charAt(0) == '\'' && tagB.charAt(match.length() - 1) == '\'') {
                match = tagB.substring(1, tagB.length() - 1);
                match = this.unescape(match);
            }
            if (isNeg) {
                return !tagValueA.equals(match);
            }
            return tagValueA.equals(match);
        }
        parts = test.split("=~");
        boolean neg = false;
        if (parts.length != 2) {
            parts = test.split("!~");
            neg = true;
            if (parts.length != 2) {
                return false;
            }
        }
        String var = parts[0].trim();
        String regex = parts[1].trim();
        Object tagValue = context.get(var);
        boolean isMatch = this.isMatch(tagValue == null ? null : tagValue.toString(), regex);
        if (neg) {
            return !isMatch;
        }
        return isMatch;
    }

    private String unescape(String x) {
        return RegexFilter.parseRegexEscapes(x);
    }

    private boolean isMatch(String text, String regex) {
        int regexEnd;
        int cursor;
        if (text == null || regex == null) {
            return false;
        }
        if ((regex = regex.trim()).charAt(cursor = 0) == 'm') {
            ++cursor;
        }
        if (regex.charAt(cursor) == '/') {
            ++cursor;
        }
        if ((regexEnd = RegexFilter.nextRegexDelim(regex, cursor)) < 0) {
            return false;
        }
        String pattern = regex.substring(cursor, regexEnd);
        boolean ignoreCase = false;
        boolean multiLine = false;
        boolean dotAll = false;
        for (int i = regex.length() - 1; i > regexEnd; --i) {
            char option = regex.charAt(i);
            if (option == 'i') {
                ignoreCase = true;
            }
            if (option == 'm') {
                multiLine = true;
            }
            if (option != 's') continue;
            dotAll = true;
        }
        if (multiLine) {
            pattern = "(?m)" + pattern;
        }
        if (ignoreCase) {
            pattern = "(?i)" + pattern;
        }
        if (dotAll) {
            pattern = "(?s)" + pattern;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(text);
        return m.find();
    }

    @Override
    public boolean doSmartTrimAroundBlock() {
        return true;
    }

    private String trimLeft(String x) {
        if (x == null) {
            return null;
        }
        int i = 0;
        char c = x.charAt(i);
        while ((c == '\n' || c == ' ' || c == '\r' || c == '\t') && ++i != x.length()) {
            c = x.charAt(i);
        }
        if (i == 0) {
            return x;
        }
        return x.substring(i);
    }

    private String trimRight(String x) {
        if (x == null) {
            return null;
        }
        int i = x.length() - 1;
        char c = x.charAt(i);
        while ((c == '\n' || c == ' ' || c == '\r' || c == '\t') && --i != -1) {
            c = x.charAt(i);
        }
        if (++i >= x.length()) {
            return x;
        }
        return x.substring(0, i);
    }

    private boolean isTrimAll() {
        String trimOpt;
        String string = trimOpt = this.options != null ? this.options.get("trim") : null;
        return trimOpt != null && (trimOpt.equals("all") || trimOpt.equals("true"));
    }

    private String smartTrim(String x) {
        return this.smartTrim(x, false);
    }

    private String smartTrim(String x, boolean ignoreAll) {
        int firstLF;
        if (!ignoreAll && this.isTrimAll()) {
            return x.trim();
        }
        Matcher m = UNIVERSAL_LF.matcher(x);
        if (m.find() && x.substring(0, firstLF = m.start()).trim().length() == 0) {
            return x.substring(m.end());
        }
        return x;
    }

    private int nextElseTag(List<SnippetPart> bodyParts, int startAt) {
        for (int i = startAt; i < bodyParts.size(); ++i) {
            SnippetTag tag;
            SnippetPart part = bodyParts.get(i);
            if (!(part instanceof SnippetTag) || !(tag = (SnippetTag)part).getTag().startsWith(".else")) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void renderBlock(Writer out, Chunk context, String origin, int depth) throws IOException {
        List<SnippetPart> bodyParts = this.body.getParts();
        int nextElseTag = this.nextElseTag(bodyParts, 0);
        if (this.isTrueExpr(this.primaryCond, context)) {
            if (nextElseTag < 0) {
                nextElseTag = bodyParts.size();
            }
            this.renderChosenParts(out, context, origin, depth, bodyParts, 0, nextElseTag);
        } else {
            while (nextElseTag > -1) {
                String elseTag = ((SnippetTag)bodyParts.get(nextElseTag)).getTag();
                if (elseTag.equals(".else")) {
                    this.renderChosenParts(out, context, origin, depth, bodyParts, nextElseTag + 1, bodyParts.size());
                    break;
                }
                String elseIfCond = this.parseCond(elseTag);
                if (this.isTrueExpr(elseIfCond, context)) {
                    int nextBoundary = this.nextElseTag(bodyParts, nextElseTag + 1);
                    if (nextBoundary == -1) {
                        nextBoundary = bodyParts.size();
                    }
                    this.renderChosenParts(out, context, origin, depth, bodyParts, nextElseTag + 1, nextBoundary);
                    break;
                }
                nextElseTag = this.nextElseTag(bodyParts, nextElseTag + 1);
            }
        }
    }

    public void renderChosenParts(Writer out, Chunk context, String origin, int depth, List<SnippetPart> parts, int a, int b) throws IOException {
        block10: {
            block11: {
                block12: {
                    block9: {
                        if (this.doTrim) break block9;
                        for (int i = a; i < b; ++i) {
                            SnippetPart part = parts.get(i);
                            part.render(out, context, origin, depth);
                        }
                        break block10;
                    }
                    if (b <= a) break block10;
                    if (!this.isTrimAll()) break block11;
                    while (parts.get(a) instanceof SnippetComment && a < b - 1) {
                        ++a;
                    }
                    if (a + 1 != b) break block12;
                    SnippetPart onlyPart = parts.get(a);
                    if (onlyPart.isLiteral()) {
                        String trimmed = onlyPart.getText().trim();
                        out.append(trimmed);
                    } else {
                        onlyPart.render(out, context, origin, depth);
                    }
                    break block10;
                }
                SnippetPart partA = parts.get(a);
                if (partA.isLiteral()) {
                    String trimmed = this.trimLeft(partA.getText());
                    out.append(trimmed);
                }
                for (int i = a + 1; i < b - 1; ++i) {
                    SnippetPart part = parts.get(i);
                    part.render(out, context, origin, depth);
                }
                SnippetPart partB = parts.get(b - 1);
                if (!partB.isLiteral()) break block10;
                String trimmed = this.trimRight(partB.getText());
                out.append(trimmed);
                break block10;
            }
            SnippetPart partA = parts.get(a);
            if (partA.isLiteral()) {
                String smartTrimmed = this.smartTrim(partA.getText());
                out.append(smartTrimmed);
            } else {
                partA.render(out, context, origin, depth);
            }
            for (int i = a + 1; i < b; ++i) {
                SnippetPart part = parts.get(i);
                part.render(out, context, origin, depth);
            }
        }
    }
}

