/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;

public class SelectedFilter
extends BasicFilter
implements ChunkFilter {
    private static final String SELECTED_TOKEN = " selected=\"selected\" ";
    private static final String CHECKED_TOKEN = " checked=\"checked\" ";

    public String transformText(Chunk chunk, String text, String[] args) {
        return text == null ? null : SelectedFilter.selected(chunk, text, args);
    }

    public String getFilterName() {
        return "selected";
    }

    public String[] getFilterAliases() {
        return new String[]{"select", "sel"};
    }

    private static String selected(Chunk context, String text, String[] args) {
        return SelectedFilter.selected(context, text, args, SELECTED_TOKEN);
    }

    protected static String checked(Chunk context, String text, String[] args) {
        return SelectedFilter.selected(context, text, args, CHECKED_TOKEN);
    }

    private static String selected(Chunk context, String text, String[] args, String token) {
        if (args == null) {
            return token;
        }
        String testValue = args[0];
        if (args.length > 1) {
            testValue = args[1];
        }
        if (args.length > 2) {
            token = args[2];
        }
        if (testValue.charAt(0) == '~' || testValue.charAt(0) == '$') {
            Object value = context.get(testValue.substring(1));
            if (value != null && text.equals(value.toString())) {
                return token;
            }
            return "";
        }
        if (text.equals(testValue)) {
            return token;
        }
        return "";
    }
}

