/*
 * Decompiled with CFR 0.152.
 */
package com.wunderlist.slidinglayer.transformer;

import android.view.View;
import com.wunderlist.slidinglayer.LayerTransformer;

public final class RotationTransformer
extends LayerTransformer {
    private static final int DEFAULT_ANGLE = 10;
    private final float mMaxAngle;
    private float mAngle;

    public RotationTransformer() {
        this(10.0f);
    }

    public RotationTransformer(float maxAngle) {
        this.mMaxAngle = maxAngle;
    }

    @Override
    protected void onMeasure(View layerView, int screenSide) {
        int[] pivotPosition = this.pivotPositionForScreenSide(layerView, screenSide);
        layerView.setPivotX((float)pivotPosition[0]);
        layerView.setPivotY((float)pivotPosition[1]);
        this.mAngle = this.mMaxAngle * (float)(screenSide == -2 || screenSide == -3 ? -1 : 1);
    }

    @Override
    public void transform(View layerView, float previewProgress, float layerProgress) {
    }

    @Override
    protected void internalTransform(View layerView, float previewProgress, float layerProgress, int screenSide) {
        float progressRatioToAnimate = Math.max(previewProgress, layerProgress);
        layerView.setRotation(this.mAngle * (1.0f - progressRatioToAnimate));
    }

    private int[] pivotPositionForScreenSide(View layerView, int screenSide) {
        switch (screenSide) {
            case -2: {
                return new int[]{0, layerView.getMeasuredHeight()};
            }
            case -3: {
                return new int[]{0, 0};
            }
            case -1: {
                return new int[]{layerView.getMeasuredWidth(), layerView.getMeasuredHeight()};
            }
            case -4: {
                return new int[]{0, layerView.getMeasuredHeight()};
            }
        }
        return new int[]{0, 0};
    }
}

