/*
 * Decompiled with CFR 0.152.
 */
package com.wunderlist.slidinglayer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import com.wunderlist.slidinglayer.LayerTransformer;
import com.wunderlist.slidinglayer.R;
import java.util.Random;

public class SlidingLayer
extends FrameLayout {
    private static final String STATE_KEY = "state";
    public static final int STICK_TO_RIGHT = -1;
    public static final int STICK_TO_LEFT = -2;
    public static final int STICK_TO_TOP = -3;
    public static final int STICK_TO_BOTTOM = -4;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private static final int HIGH_VELOCITY = 9000;
    private static final int MAX_SCROLLING_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 10;
    private static final Interpolator sMenuInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (float)Math.pow(t -= 1.0f, 5.0) + 1.0f;
        }
    };
    private static final int INVALID_VALUE = -1;
    protected int mActivePointerId = -1;
    protected VelocityTracker mVelocityTracker;
    protected int mMaximumVelocity;
    private Random mRandom;
    protected Bundle mState;
    private Scroller mScroller;
    private int mShadowSize;
    private Drawable mShadowDrawable;
    private boolean mForceLayout;
    private int mOffsetDistance;
    private boolean mDrawingCacheEnabled;
    private int mScreenSide;
    private boolean changeStateOnTap = true;
    private int mPreviewOffsetDistance = -1;
    private boolean mEnabled = true;
    private boolean mSlidingFromShadowEnabled = true;
    private boolean mIsDragging;
    private boolean mIsUnableToDrag;
    private int mTouchSlop;
    private float mLastX = -1.0f;
    private float mLastY = -1.0f;
    private float mInitialX = -1.0f;
    private float mInitialY = -1.0f;
    private float mInitialRawX = -1.0f;
    private float mInitialRawY = -1.0f;
    private static final int STATE_CLOSED = 0;
    private static final int STATE_PREVIEW = 1;
    private static final int STATE_OPENED = 2;
    private int mCurrentState;
    private boolean mScrolling;
    private OnInteractListener mOnInteractListener;
    private OnScrollListener mOnScrollListener;
    private int mMinimumVelocity;
    private int mFlingDistance;
    private LayerTransformer mLayerTransformer;

    public SlidingLayer(Context context) {
        this(context, null);
    }

    public SlidingLayer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingLayer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SlidingLayer);
        this.setStickTo(ta.getInt(R.styleable.SlidingLayer_stickTo, -1));
        int shadowRes = ta.getResourceId(R.styleable.SlidingLayer_shadowDrawable, -1);
        if (shadowRes != -1) {
            this.setShadowDrawable(shadowRes);
        }
        this.mShadowSize = (int)ta.getDimension(R.styleable.SlidingLayer_shadowSize, 0.0f);
        this.changeStateOnTap = ta.getBoolean(R.styleable.SlidingLayer_changeStateOnTap, true);
        this.mOffsetDistance = ta.getDimensionPixelOffset(R.styleable.SlidingLayer_offsetDistance, 0);
        this.mPreviewOffsetDistance = ta.getDimensionPixelOffset(R.styleable.SlidingLayer_previewOffsetDistance, -1);
        this.checkPreviewModeConsistency();
        ta.recycle();
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sMenuInterpolator);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        float density = context.getResources().getDisplayMetrics().density;
        this.mFlingDistance = (int)(10.0f * density);
        this.mRandom = new Random();
    }

    private int getCurrentState() {
        return this.mCurrentState;
    }

    public boolean isOpened() {
        return this.mCurrentState == 2;
    }

    public boolean isInPreviewMode() {
        return this.mCurrentState == 1;
    }

    public boolean isClosed() {
        return this.mCurrentState == 0;
    }

    public void openLayer(boolean smoothAnimation) {
        this.setLayerState(2, smoothAnimation);
    }

    public void openPreview(boolean smoothAnimation) {
        if (this.mPreviewOffsetDistance == -1) {
            throw new IllegalStateException("A value offset for the preview has to be specified in order to open the layer in preview mode. Use setPreviewOffsetDistance or set its associated XML property ");
        }
        this.setLayerState(1, smoothAnimation);
    }

    public void closeLayer(boolean smoothAnimation) {
        this.setLayerState(0, smoothAnimation);
    }

    private void setLayerState(int state, boolean smoothAnimation) {
        this.setLayerState(state, smoothAnimation, false);
    }

    private void setLayerState(int state, boolean smoothAnimation, boolean force) {
        this.setLayerState(state, smoothAnimation, force, 0, 0);
    }

    private void setLayerState(int state, boolean smoothAnimation, boolean force, int velocityX, int velocityY) {
        if (!force && this.mCurrentState == state) {
            this.setDrawingCacheEnabled(false);
            return;
        }
        if (this.mOnInteractListener != null) {
            this.notifyActionStartedForState(state);
        }
        int[] pos = this.getDestScrollPosForState(state);
        if (smoothAnimation) {
            int velocity = this.allowedDirection() == 0 ? velocityX : velocityY;
            this.smoothScrollTo(pos[0], pos[1], velocity);
        } else {
            this.completeScroll();
            this.scrollToAndNotify(pos[0], pos[1]);
        }
        this.mCurrentState = state;
    }

    public void setOnInteractListener(OnInteractListener listener) {
        this.mOnInteractListener = listener;
    }

    public void setOnScrollListener(OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public void setLayerTransformer(LayerTransformer layerTransformer) {
        this.mLayerTransformer = layerTransformer;
    }

    public void setShadowSize(int shadowSize) {
        this.mShadowSize = shadowSize;
        this.invalidate(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }

    public void setShadowSizeRes(int resId) {
        this.setShadowSize((int)this.getResources().getDimension(resId));
    }

    public int getShadowSize() {
        return this.mShadowSize;
    }

    public void setShadowDrawable(Drawable d) {
        this.mShadowDrawable = d;
        this.refreshDrawableState();
        this.setWillNotDraw(false);
        this.invalidate(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }

    public void setShadowDrawable(int resId) {
        this.setShadowDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public void setOffsetDistanceRes(int resId) {
        this.setOffsetDistance((int)this.getResources().getDimension(resId));
    }

    public void setOffsetDistance(int offsetDistance) {
        this.mOffsetDistance = offsetDistance;
        this.checkPreviewModeConsistency();
        this.invalidate(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }

    public int getOffsetDistance() {
        return this.mOffsetDistance;
    }

    public void setPreviewOffsetDistanceRes(int resId) {
        this.setPreviewOffsetDistance((int)this.getResources().getDimension(resId));
    }

    public void setPreviewOffsetDistance(int previewOffsetDistance) {
        this.mPreviewOffsetDistance = previewOffsetDistance;
        this.checkPreviewModeConsistency();
        this.invalidate(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        if (this.mCurrentState == 1) {
            this.smoothScrollToCurrentPosition();
        }
    }

    private void checkPreviewModeConsistency() {
        if (this.isPreviewModeEnabled() && this.mOffsetDistance > this.mPreviewOffsetDistance) {
            throw new IllegalStateException("The showing offset of the layer can never be greater than the offset dimension of the preview mode");
        }
    }

    private boolean isPreviewModeEnabled() {
        return this.mPreviewOffsetDistance != -1;
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mShadowDrawable;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.mShadowDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    public boolean isSlidingEnabled() {
        return this.mEnabled;
    }

    public void setSlidingEnabled(boolean _enabled) {
        this.mEnabled = _enabled;
    }

    public boolean isSlidingFromShadowEnabled() {
        return this.mSlidingFromShadowEnabled;
    }

    public void setSlidingFromShadowEnabled(boolean _slidingShadow) {
        this.mSlidingFromShadowEnabled = _slidingShadow;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState state = new SavedState(superState);
        if (this.mState == null) {
            this.mState = new Bundle();
        }
        this.mState.putInt(STATE_KEY, this.mCurrentState);
        state.mState = this.mState;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.restoreState((Parcelable)savedState.mState);
    }

    public void restoreState(Parcelable in) {
        this.mState = (Bundle)in;
        int state = this.mState.getInt(STATE_KEY);
        this.setLayerState(state, true);
    }

    private float getViewX(MotionEvent event) {
        return event.getRawX();
    }

    private float getViewY(MotionEvent event) {
        return event.getRawY();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mEnabled) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1) {
            this.mIsDragging = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        if (action != 0) {
            if (this.mIsDragging) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (action) {
            case 2: {
                boolean validVerticalDrag;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
                float x = this.getViewX(ev);
                float dx = x - this.mLastX;
                float xDiff = Math.abs(dx);
                float y = this.getViewY(ev);
                float dy = y - this.mLastY;
                float yDiff = Math.abs(dy);
                if ((dx != 0.0f || dy != 0.0f) && this.canScroll((View)this, false, (int)dx, (int)dy, (int)x, (int)y)) {
                    this.mLastX = this.mInitialRawX = x;
                    this.mLastY = this.mInitialRawY = y;
                    this.mInitialX = ev.getX(pointerIndex);
                    this.mInitialY = ev.getY(pointerIndex);
                    return false;
                }
                boolean validHorizontalDrag = xDiff > (float)this.mTouchSlop && xDiff > yDiff;
                boolean bl = validVerticalDrag = yDiff > (float)this.mTouchSlop && yDiff > xDiff;
                if (validHorizontalDrag) {
                    this.mLastX = x;
                } else if (validVerticalDrag) {
                    this.mLastY = y;
                }
                if (!validHorizontalDrag && !validVerticalDrag) break;
                this.mIsDragging = true;
                this.setDrawingCacheEnabled(true);
                break;
            }
            case 0: {
                this.mLastX = this.mInitialRawX = this.getViewX(ev);
                this.mLastY = this.mInitialRawY = this.getViewY(ev);
                this.mInitialX = ev.getX(0);
                this.mInitialY = ev.getY(0);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                if (this.touchPointIsWithinBounds(ev.getX(), ev.getY())) {
                    this.mIsDragging = false;
                    this.mIsUnableToDrag = false;
                    return super.onInterceptTouchEvent(ev);
                }
                this.completeScroll();
                this.mIsDragging = false;
                this.mIsUnableToDrag = true;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (!this.mIsDragging) {
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(ev);
        }
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (!this.mEnabled || !this.mIsDragging && !this.touchPointIsWithinBounds(this.mInitialX, this.mInitialY)) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.completeScroll();
                this.mLastX = this.mInitialRawX = this.getViewX(ev);
                this.mLastY = this.mInitialRawY = this.getViewY(ev);
                this.mInitialX = ev.getX();
                this.mInitialY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                float leftBound;
                float topBound;
                float bottomBound;
                float rightBound;
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (!this.touchPointIsWithinBounds(ev.getX(), ev.getY(), false)) {
                    return false;
                }
                float x = this.getViewX(ev);
                float y = this.getViewY(ev);
                float deltaX = this.mLastX - x;
                float deltaY = this.mLastY - y;
                this.mLastX = x;
                this.mLastY = y;
                if (!this.mIsDragging) {
                    boolean validVerticalDrag;
                    float xDiff = Math.abs(x - this.mInitialRawX);
                    float yDiff = Math.abs(y - this.mInitialRawY);
                    boolean validHorizontalDrag = xDiff > (float)this.mTouchSlop && xDiff > yDiff;
                    boolean bl = validVerticalDrag = yDiff > (float)this.mTouchSlop && yDiff > xDiff;
                    if (validHorizontalDrag || validVerticalDrag) {
                        this.mIsDragging = true;
                        this.setDrawingCacheEnabled(true);
                    }
                }
                if (!this.mIsDragging) break;
                float oldScrollX = this.getScrollX();
                float oldScrollY = this.getScrollY();
                float scrollX = oldScrollX + deltaX;
                float scrollY = oldScrollY + deltaY;
                switch (this.mScreenSide) {
                    case -2: {
                        rightBound = 0.0f;
                        bottomBound = 0.0f;
                        topBound = 0.0f;
                        leftBound = this.getWidth();
                        break;
                    }
                    case -1: {
                        rightBound = -this.getWidth();
                        leftBound = 0.0f;
                        bottomBound = 0.0f;
                        topBound = 0.0f;
                        break;
                    }
                    case -3: {
                        topBound = this.getHeight();
                        leftBound = 0.0f;
                        rightBound = 0.0f;
                        bottomBound = 0.0f;
                        break;
                    }
                    case -4: {
                        bottomBound = -this.getHeight();
                        leftBound = 0.0f;
                        rightBound = 0.0f;
                        topBound = 0.0f;
                        break;
                    }
                    default: {
                        leftBound = 0.0f;
                        rightBound = 0.0f;
                        bottomBound = 0.0f;
                        topBound = 0.0f;
                    }
                }
                if (scrollX > leftBound) {
                    scrollX = leftBound;
                } else if (scrollX < rightBound) {
                    scrollX = rightBound;
                }
                if (scrollY > topBound) {
                    scrollY = topBound;
                } else if (scrollY < bottomBound) {
                    scrollY = bottomBound;
                }
                this.mLastX += scrollX - (float)((int)scrollX);
                this.mLastY += scrollY - (float)((int)scrollY);
                this.scrollToAndNotify((int)scrollX, (int)scrollY);
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    int initialVelocityX = (int)VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                    int initialVelocityY = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                    int scrollX = this.getScrollX();
                    int scrollY = this.getScrollY();
                    int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                    float x = this.getViewX(ev);
                    float y = this.getViewY(ev);
                    int nextState = this.determineNextStateForDrag(scrollX, scrollY, initialVelocityX, initialVelocityY, (int)this.mInitialRawX, (int)this.mInitialRawY, (int)x, (int)y);
                    this.setLayerState(nextState, true, true, initialVelocityX, initialVelocityY);
                    this.mActivePointerId = -1;
                    this.endDrag();
                    break;
                }
                if (!this.changeStateOnTap) break;
                int nextState = this.determineNextStateAfterTap();
                this.setLayerState(nextState, true, true);
                break;
            }
            case 3: {
                if (!this.mIsDragging) break;
                this.setLayerState(this.mCurrentState, true, true);
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mLastX = this.getViewX(ev);
                this.mLastY = this.getViewY(ev);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                this.mLastX = this.getViewX(ev);
                this.mLastY = this.getViewY(ev);
                break;
            }
        }
        return true;
    }

    private boolean touchPointIsWithinBounds(float touchX, float touchY) {
        return this.touchPointIsWithinBounds(touchX, touchY, true);
    }

    private boolean touchPointIsWithinBounds(float touchX, float touchY, boolean withinLayer) {
        float touch;
        int scroll = 0;
        if (this.allowedDirection() == 0) {
            if (withinLayer) {
                scroll = this.getScrollX();
            }
            touch = touchX;
        } else {
            if (withinLayer) {
                scroll = this.getScrollY();
            }
            touch = touchY;
        }
        switch (this.mScreenSide) {
            case -4: 
            case -1: {
                return touch >= (float)(-scroll);
            }
            case -2: {
                return touch <= (float)(this.getWidth() - scroll);
            }
            case -3: {
                return touch <= (float)(this.getHeight() - scroll);
            }
        }
        throw new IllegalStateException("The layer has to be stuck to one of the sides of the screen. Current value is: " + this.mScreenSide);
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int dy, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, dy, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && (this.allowedDirection() == 0 && ViewCompat.canScrollHorizontally((View)v, (int)(-dx)) || this.allowedDirection() == 1 && ViewCompat.canScrollVertically((View)v, (int)(-dy)));
    }

    private int determineNextStateForDrag(int scrollX, int scrollY, int velocityX, int velocityY, int initialX, int initialY, int currentX, int currentY) {
        boolean isOverThreshold;
        int relativeVelocity;
        int absoluteDelta;
        int panelOffset;
        int panelSize;
        if (this.allowedDirection() == 0) {
            panelSize = this.getWidth();
            panelOffset = Math.abs(panelSize - Math.abs(scrollX));
            absoluteDelta = Math.abs(currentX - initialX);
            relativeVelocity = velocityX * (this.mScreenSide == -2 ? 1 : -1);
        } else {
            panelSize = this.getHeight();
            panelOffset = Math.abs(panelSize - Math.abs(scrollY));
            absoluteDelta = Math.abs(currentY - initialY);
            relativeVelocity = velocityY * (this.mScreenSide == -3 ? 1 : -1);
        }
        int absoluteVelocity = Math.abs(relativeVelocity);
        boolean bl = isOverThreshold = absoluteDelta > this.mFlingDistance && absoluteVelocity > this.mMinimumVelocity;
        if (isOverThreshold) {
            boolean goesToPreview;
            if (relativeVelocity > 0) {
                return 2;
            }
            boolean bl2 = goesToPreview = this.isPreviewModeEnabled() && panelOffset > this.mPreviewOffsetDistance && absoluteVelocity < 9000;
            if (goesToPreview) {
                return 1;
            }
            return 0;
        }
        int openedThreshold = (panelSize + (this.isPreviewModeEnabled() ? this.mPreviewOffsetDistance : 0)) / 2;
        if (panelOffset > openedThreshold) {
            return 2;
        }
        if (this.isPreviewModeEnabled() && panelOffset > this.mPreviewOffsetDistance / 2) {
            return 1;
        }
        return 0;
    }

    private int determineNextStateAfterTap() {
        switch (this.mCurrentState) {
            case 0: {
                return this.isPreviewModeEnabled() ? 1 : 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return this.isPreviewModeEnabled() ? 1 : 0;
            }
        }
        return 0;
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        if (this.getChildCount() == 0) {
            this.setDrawingCacheEnabled(false);
            return;
        }
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll();
            if (this.mOnInteractListener != null) {
                this.notifyActionFinished();
            }
            return;
        }
        this.setDrawingCacheEnabled(true);
        this.mScrolling = true;
        int width = this.getWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        velocity = Math.abs(velocity);
        int duration = velocity > 0 ? 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity)) : 600;
        duration = Math.min(duration, 600);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private void smoothScrollToCurrentPosition() {
        int[] pos = this.getDestScrollPosForState(this.mCurrentState);
        this.smoothScrollTo(pos[0], pos[1]);
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    private void endDrag() {
        this.mIsDragging = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void setDrawingCacheEnabled(boolean enabled) {
        if (this.mDrawingCacheEnabled != enabled) {
            super.setDrawingCacheEnabled(enabled);
            this.mDrawingCacheEnabled = enabled;
            int l = this.getChildCount();
            for (int i = 0; i < l; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                child.setDrawingCacheEnabled(enabled);
            }
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastX = ev.getX(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void completeScroll() {
        boolean needPopulate = this.mScrolling;
        if (needPopulate) {
            this.setDrawingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollToAndNotify(x, y);
            }
            if (this.mOnInteractListener != null) {
                this.notifyActionFinished();
            }
        }
        this.mScrolling = false;
    }

    private void scrollToAndNotify(int x, int y) {
        this.scrollTo(x, y);
        if (this.mOnScrollListener == null && this.mLayerTransformer == null) {
            return;
        }
        int scroll = this.allowedDirection() == 1 ? this.getHeight() - Math.abs(y) : this.getWidth() - Math.abs(x);
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(Math.abs(scroll));
        }
        if (this.mLayerTransformer != null) {
            int absoluteScroll = Math.abs(scroll);
            int layerSize = this.allowedDirection() == 0 ? this.getMeasuredWidth() : this.getMeasuredHeight();
            float layerProgress = (float)absoluteScroll / (float)layerSize;
            float previewProgress = this.mPreviewOffsetDistance > 0 ? Math.min(1.0f, (float)absoluteScroll / (float)this.mPreviewOffsetDistance) : 0.0f;
            this.mLayerTransformer.internalTransform((View)this, previewProgress, layerProgress, this.mScreenSide);
        }
    }

    public void setStickTo(int screenSide) {
        this.mForceLayout = true;
        this.mScreenSide = screenSide;
        this.setLayerState(0, false, true);
    }

    private int allowedDirection() {
        if (this.mScreenSide == -3 || this.mScreenSide == -4) {
            return 1;
        }
        if (this.mScreenSide == -2 || this.mScreenSide == -1) {
            return 0;
        }
        throw new IllegalStateException("The screen side of the layer is illegal");
    }

    public void setChangeStateOnTap(boolean changeStateOnTap) {
        this.changeStateOnTap = changeStateOnTap;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = SlidingLayer.getDefaultSize((int)0, (int)widthMeasureSpec);
        int height = SlidingLayer.getDefaultSize((int)0, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        if (this.mLayerTransformer != null) {
            this.mLayerTransformer.onMeasure((View)this, this.mScreenSide);
        }
        super.onMeasure(SlidingLayer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width), SlidingLayer.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)height));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        boolean scrollMustChange = false;
        if (this.allowedDirection() == 1) {
            if (h != oldh) {
                scrollMustChange = true;
            }
        } else if (w != oldw) {
            scrollMustChange = true;
        }
        if (scrollMustChange) {
            this.completeScroll();
            int[] pos = this.getDestScrollPosForState(this.mCurrentState);
            this.scrollTo(pos[0], pos[1]);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mForceLayout) {
            this.mForceLayout = false;
            this.adjustLayoutParams();
            if (this.mScreenSide == -1) {
                this.setPadding(this.getPaddingLeft() + this.mShadowSize, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
            } else if (this.mScreenSide == -4) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop() + this.mShadowSize, this.getPaddingRight(), this.getPaddingBottom());
            } else if (this.mScreenSide == -2) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight() + this.mShadowSize, this.getPaddingBottom());
            } else if (this.mScreenSide == -3) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom() + this.mShadowSize);
            }
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    private void adjustLayoutParams() {
        ViewGroup.LayoutParams baseParams = this.getLayoutParams();
        if (baseParams instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)baseParams;
            switch (this.mScreenSide) {
                case -4: {
                    layoutParams.gravity = 80;
                    break;
                }
                case -2: {
                    layoutParams.gravity = 3;
                    break;
                }
                case -1: {
                    layoutParams.gravity = 5;
                    break;
                }
                case -3: {
                    layoutParams.gravity = 48;
                }
            }
            this.setLayoutParams(baseParams);
        } else if (baseParams instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)baseParams;
            switch (this.mScreenSide) {
                case -4: {
                    layoutParams.addRule(12);
                    break;
                }
                case -2: {
                    layoutParams.addRule(9);
                    break;
                }
                case -1: {
                    layoutParams.addRule(11);
                    break;
                }
                case -3: {
                    layoutParams.addRule(10);
                }
            }
        }
    }

    private int[] getDestScrollPosForState(int state) {
        int[] pos = new int[2];
        if (state == 2) {
            return pos;
        }
        int layerOffset = state == 0 ? this.mOffsetDistance : this.mPreviewOffsetDistance;
        switch (this.mScreenSide) {
            case -1: {
                pos[0] = -this.getWidth() + layerOffset;
                break;
            }
            case -2: {
                pos[0] = this.getWidth() - layerOffset;
                break;
            }
            case -3: {
                pos[1] = this.getHeight() - layerOffset;
                break;
            }
            case -4: {
                pos[1] = -this.getHeight() + layerOffset;
            }
        }
        return pos;
    }

    public int getContentLeft() {
        return this.getLeft() + this.getPaddingLeft();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mShadowSize > 0 && this.mShadowDrawable != null) {
            if (this.mScreenSide == -1) {
                this.mShadowDrawable.setBounds(0, 0, this.mShadowSize, this.getHeight());
            }
            if (this.mScreenSide == -3) {
                this.mShadowDrawable.setBounds(0, this.getHeight() - this.mShadowSize, this.getWidth(), this.getHeight());
            }
            if (this.mScreenSide == -2) {
                this.mShadowDrawable.setBounds(this.getWidth() - this.mShadowSize, 0, this.getWidth(), this.getHeight());
            }
            if (this.mScreenSide == -4) {
                this.mShadowDrawable.setBounds(0, 0, this.getWidth(), this.mShadowSize);
            }
            this.mShadowDrawable.draw(canvas);
        }
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollToAndNotify(x, y);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll();
    }

    private void notifyActionStartedForState(int state) {
        switch (state) {
            case 0: {
                this.mOnInteractListener.onClose();
                break;
            }
            case 1: {
                this.mOnInteractListener.onShowPreview();
                break;
            }
            case 2: {
                this.mOnInteractListener.onOpen();
            }
        }
    }

    private void notifyActionFinished() {
        switch (this.mCurrentState) {
            case 0: {
                this.mOnInteractListener.onClosed();
                break;
            }
            case 1: {
                this.mOnInteractListener.onPreviewShowed();
                break;
            }
            case 2: {
                this.mOnInteractListener.onOpened();
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        Bundle mState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in) {
            super(in);
            this.mState = in.readBundle();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeBundle(this.mState);
        }
    }

    public static interface OnScrollListener {
        public void onScroll(int var1);
    }

    public static interface OnInteractListener {
        public void onOpen();

        public void onShowPreview();

        public void onClose();

        public void onOpened();

        public void onPreviewShowed();

        public void onClosed();
    }
}

