/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.poi;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.services.poi.OnPoiSearchCompletedListener;
import com.eegeo.mapapi.services.poi.PoiApi;
import com.eegeo.mapapi.services.poi.PoiSearchResponse;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class PoiSearch
extends NativeApiObject {
    private PoiApi m_poiApi;
    private OnPoiSearchCompletedListener m_callback = null;

    @UiThread
    PoiSearch(PoiApi poiApi, OnPoiSearchCompletedListener callback, Callable<Integer> beginSearchCallable) {
        super(poiApi.getNativeRunner(), poiApi.getUiRunner(), beginSearchCallable);
        this.m_poiApi = poiApi;
        this.m_callback = callback;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                PoiSearch.this.m_poiApi.register(PoiSearch.this, PoiSearch.this.getNativeHandle());
            }
        });
    }

    @UiThread
    public void cancel() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                PoiSearch.this.m_poiApi.cancelSearch(PoiSearch.this.getNativeHandle());
            }
        });
    }

    @UiThread
    void returnSearchResults(PoiSearchResponse searchResults) {
        if (this.m_callback != null) {
            this.m_callback.onPoiSearchCompleted(searchResults);
        }
    }
}

