/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.indoors;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.eegeo.mapapi.R;
import java.util.ArrayList;
import java.util.List;

public class IndoorFloorListAdapter
extends BaseAdapter {
    private int m_itemViewId;
    private List<String> m_nameData;

    public IndoorFloorListAdapter(int itemViewId) {
        this.m_itemViewId = itemViewId;
        this.m_nameData = new ArrayList<String>();
    }

    public void setData(List<String> nameData) {
        this.m_nameData = nameData;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.m_nameData.size();
    }

    public Object getItem(int index) {
        return this.m_nameData.get(index);
    }

    public long getItemId(int index) {
        return index;
    }

    public View getView(int index, View contextView, ViewGroup parent) {
        View bottomLine;
        String floorName = (String)this.getItem(index);
        if (contextView == null) {
            LayoutInflater inflater = (LayoutInflater)parent.getContext().getSystemService("layout_inflater");
            contextView = inflater.inflate(this.m_itemViewId, null);
        }
        TextView nameLabel = (TextView)contextView.findViewById(R.id.floor_name);
        nameLabel.setText((CharSequence)floorName);
        nameLabel.setHorizontallyScrolling(false);
        nameLabel.setSingleLine();
        View upperLine = contextView.findViewById(R.id.interiors_explorer_floor_list_item_topline);
        if (upperLine != null) {
            upperLine.setVisibility(index == 0 ? 4 : 0);
        }
        if ((bottomLine = contextView.findViewById(R.id.interiors_explorer_floor_list_item_bottomline)) != null) {
            bottomLine.setVisibility(index == this.m_nameData.size() - 1 ? 4 : 0);
        }
        return contextView;
    }
}

