/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi;

import android.support.annotation.UiThread;
import android.view.MotionEvent;
import com.eegeo.mapapi.EegeoNativeMapView;

final class MapViewTouchHandler {
    private EegeoNativeMapView m_eegeoNativeMapView;

    MapViewTouchHandler(EegeoNativeMapView eegeoNativeMapView) {
        this.m_eegeoNativeMapView = eegeoNativeMapView;
    }

    @UiThread
    public boolean onTouchEvent(MotionEvent e) {
        int pointerCount = e.getPointerCount();
        int primaryActionIndex = e.getActionIndex();
        int primaryActionIdentifier = e.getPointerId(primaryActionIndex);
        float[] xArray = new float[pointerCount];
        float[] yArray = new float[pointerCount];
        int[] pointerIdentityArray = new int[pointerCount];
        int[] pointerIndexArray = new int[pointerCount];
        for (int pointerIndex = 0; pointerIndex < pointerCount; ++pointerIndex) {
            xArray[pointerIndex] = e.getX(pointerIndex);
            yArray[pointerIndex] = e.getY(pointerIndex);
            pointerIdentityArray[pointerIndex] = e.getPointerId(pointerIndex);
            pointerIndexArray[pointerIndex] = pointerIndex;
        }
        boolean handled = true;
        switch (e.getActionMasked()) {
            case 0: 
            case 5: {
                this.m_eegeoNativeMapView.onPointerDown(primaryActionIndex, primaryActionIdentifier, pointerCount, xArray, yArray, pointerIdentityArray, pointerIndexArray);
                break;
            }
            case 1: 
            case 6: {
                this.m_eegeoNativeMapView.onPointerUp(primaryActionIndex, primaryActionIdentifier, pointerCount, xArray, yArray, pointerIdentityArray, pointerIndexArray);
                break;
            }
            case 2: {
                this.m_eegeoNativeMapView.onPointerMove(primaryActionIndex, primaryActionIdentifier, pointerCount, xArray, yArray, pointerIdentityArray, pointerIndexArray);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }
}

