/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.mapscene;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.services.mapscene.MapsceneApi;
import com.eegeo.mapapi.services.mapscene.MapsceneRequestResponse;
import com.eegeo.mapapi.services.mapscene.OnMapsceneRequestCompletedListener;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class MapsceneRequest
extends NativeApiObject {
    private MapsceneApi m_mapsceneApi;
    private final boolean m_applyOnLoad;
    private OnMapsceneRequestCompletedListener m_callback = null;

    @UiThread
    MapsceneRequest(MapsceneApi mapsceneApi, boolean applyOnLoad, OnMapsceneRequestCompletedListener callback, Callable<Integer> beginRequestCallable) {
        super(mapsceneApi.getNativeRunner(), mapsceneApi.getUiRunner(), beginRequestCallable);
        this.m_mapsceneApi = mapsceneApi;
        this.m_applyOnLoad = applyOnLoad;
        this.m_callback = callback;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                MapsceneRequest.this.m_mapsceneApi.register(MapsceneRequest.this, MapsceneRequest.this.getNativeHandle());
            }
        });
    }

    public boolean shouldApplyOnLoad() {
        return this.m_applyOnLoad;
    }

    @UiThread
    public void cancel() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                MapsceneRequest.this.m_mapsceneApi.cancelRequest(MapsceneRequest.this.getNativeHandle());
            }
        });
    }

    @UiThread
    void returnResponse(MapsceneRequestResponse mapsceneResponse) {
        if (this.m_callback != null) {
            this.m_callback.onMapsceneRequestCompleted(mapsceneResponse);
        }
    }
}

