/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.web;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.web.ConnectivityQuerier;
import com.eegeo.web.ConnectivityServiceJniMethods;
import com.eegeo.web.WifiSSIDQuerier;

public class NetworkChangeReceiver
extends BroadcastReceiver {
    public static String NETWORK_STATUS_CHANGED_INTENT = "com.eegeo.web.NETWORK_STATUS_CHANGED";
    protected long m_nativeCallerPointer;
    private INativeMessageRunner m_messageRunner;

    public NetworkChangeReceiver(INativeMessageRunner messageRunner, long nativeCallerPointer) {
        this.m_messageRunner = messageRunner;
        this.m_nativeCallerPointer = nativeCallerPointer;
    }

    public void onReceive(Context context, Intent intent) {
        final Context localContext = context;
        this.m_messageRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                int networkStatus = ConnectivityQuerier.getConnectivityStatus(localContext);
                String ssid = networkStatus == ConnectivityQuerier.WIFI ? WifiSSIDQuerier.getWifiSSID(localContext) : "";
                ConnectivityServiceJniMethods.SetConnectivityType(NetworkChangeReceiver.this.m_nativeCallerPointer, networkStatus, ssid);
            }
        });
    }
}

