/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.tag;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.services.tag.OnTagsLoadCompletedListener;
import com.eegeo.mapapi.util.Promise;

public class TagApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private Boolean m_hasLoadedTags;
    private Boolean m_loadInProgress;
    private OnTagsLoadCompletedListener m_listener;

    public TagApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
        this.m_hasLoadedTags = false;
        this.m_loadInProgress = false;
        this.m_listener = null;
    }

    @UiThread
    public Promise<String> getIconUrlByKey(String iconKey) {
        final String iconKeyInput = iconKey;
        final Promise<String> p = new Promise<String>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final String nativeResult = TagApi.this.nativeGetIconUrlForIconKey(TagApi.this.m_jniEegeoMapApiPtr, iconKeyInput);
                TagApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(nativeResult);
                    }
                });
            }
        });
        return p;
    }

    @UiThread
    public Promise<String> getIconKeyForTags(String tags) {
        final String tagsInput = tags;
        final Promise<String> p = new Promise<String>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final String nativeResult = TagApi.this.nativeGetIconKeyForTagsString(TagApi.this.m_jniEegeoMapApiPtr, tagsInput);
                TagApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(nativeResult);
                    }
                });
            }
        });
        return p;
    }

    public Promise<String> getIconUrlForTags(String tags) {
        final String tagsInput = tags;
        final Promise<String> p = new Promise<String>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final String nativeResult = TagApi.this.nativeGetIconUrlForTagsString(TagApi.this.m_jniEegeoMapApiPtr, tagsInput);
                TagApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(nativeResult);
                    }
                });
            }
        });
        return p;
    }

    public Promise<String[]> getReadableTagsForTags(String tags) {
        final String tagsInput = tags;
        final Promise<String[]> p = new Promise<String[]>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final String[] nativeResult = TagApi.this.nativeGetReadableTagsForTagsString(TagApi.this.m_jniEegeoMapApiPtr, tagsInput);
                TagApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(nativeResult);
                    }
                });
            }
        });
        return p;
    }

    @UiThread
    public void loadTags(OnTagsLoadCompletedListener listener) {
        if (this.m_loadInProgress.booleanValue()) {
            throw new UnsupportedOperationException("Unable to load Tags - load already in progress!");
        }
        this.m_listener = listener;
        this.m_loadInProgress = true;
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                TagApi.this.nativeLoadTags(TagApi.this.m_jniEegeoMapApiPtr);
            }
        });
    }

    @UiThread
    public Boolean hasLoadedTags() {
        return this.m_hasLoadedTags;
    }

    @WorkerThread
    public void notifyTagsLoaded() {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                TagApi.this.m_hasLoadedTags = true;
                TagApi.this.m_loadInProgress = false;
                if (TagApi.this.m_listener != null) {
                    TagApi.this.m_listener.onTagsLoadCompleted();
                }
                TagApi.this.m_listener = null;
            }
        });
    }

    private native int nativeLoadTags(long var1);

    private native String nativeGetIconUrlForIconKey(long var1, String var3);

    private native String nativeGetIconKeyForTagsString(long var1, String var3);

    private native String nativeGetIconUrlForTagsString(long var1, String var3);

    private native String[] nativeGetReadableTagsForTagsString(long var1, String var3);
}

