/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.picking;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.picking.PickResult;
import com.eegeo.mapapi.util.Promise;

public class PickingApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;

    public PickingApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public Promise<PickResult> pickFeatureAtScreenPoint(final @NonNull Point point) {
        final Promise<PickResult> p = new Promise<PickResult>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final PickResult pickResult = PickingApi.this.nativePickFeatureAtScreenPoint(PickingApi.this.m_jniEegeoMapApiPtr, point.x, point.y);
                PickingApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(pickResult);
                    }
                });
            }
        });
        return p;
    }

    @UiThread
    public Promise<PickResult> pickFeatureAtLatLng(final @NonNull LatLng latLng) {
        final Promise<PickResult> p = new Promise<PickResult>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final PickResult pickResult = PickingApi.this.nativePickFeatureAtLatLng(PickingApi.this.m_jniEegeoMapApiPtr, latLng.latitude, latLng.longitude);
                PickingApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(pickResult);
                    }
                });
            }
        });
        return p;
    }

    @WorkerThread
    private native PickResult nativePickFeatureAtScreenPoint(long var1, double var3, double var5);

    @WorkerThread
    private native PickResult nativePickFeatureAtLatLng(long var1, double var3, double var5);
}

