/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.pointonpath;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.LatLngHelpers;
import com.eegeo.mapapi.pointonpath.PointOnPath;
import com.eegeo.mapapi.pointonpath.PointOnRoute;
import com.eegeo.mapapi.pointonpath.PointOnRouteOptions;
import com.eegeo.mapapi.services.routing.Route;
import com.eegeo.mapapi.util.Promise;
import java.util.List;

public class PointOnPathApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;

    public PointOnPathApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public Promise<PointOnRoute> getPointOnRoute(final LatLng point, final Route route, final PointOnRouteOptions pointOnRouteOptions) {
        final Promise<PointOnRoute> p = new Promise<PointOnRoute>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final PointOnRoute pointOnRoute = PointOnPathApi.this.nativeGetPointOnRoute(PointOnPathApi.this.m_jniEegeoMapApiPtr, point.latitude, point.longitude, route, pointOnRouteOptions);
                PointOnPathApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(pointOnRoute);
                    }
                });
            }
        });
        return p;
    }

    @WorkerThread
    private native PointOnRoute nativeGetPointOnRoute(long var1, double var3, double var5, Route var7, PointOnRouteOptions var8);

    @UiThread
    public Promise<PointOnPath> getPointOnPath(final LatLng point, final List<LatLng> path) {
        final Promise<PointOnPath> p = new Promise<PointOnPath>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                double[] latLongs = LatLngHelpers.pointsToArray(path);
                final PointOnPath pointOnPath = PointOnPathApi.this.nativeGetPointOnPath(PointOnPathApi.this.m_jniEegeoMapApiPtr, point.latitude, point.longitude, latLongs);
                PointOnPathApi.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(pointOnPath);
                    }
                });
            }
        });
        return p;
    }

    @WorkerThread
    private native PointOnPath nativeGetPointOnPath(long var1, double var3, double var5, double[] var7);
}

