/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.buildings;

import android.graphics.Point;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.buildings.BuildingHighlight;
import com.eegeo.mapapi.buildings.BuildingHighlightOptions;
import com.eegeo.mapapi.buildings.BuildingInformation;
import com.eegeo.mapapi.geometry.LatLng;
import java.security.InvalidParameterException;

public class BuildingsApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<BuildingHighlight> m_nativeHandleToBuildingHighlight = new SparseArray();

    public BuildingsApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void register(BuildingHighlight buildingHighlight, BuildingHighlight.AllowHandleAccess allowHandleAccess) {
        int nativeHandle = buildingHighlight.getNativeHandle(allowHandleAccess);
        this.m_nativeHandleToBuildingHighlight.put(nativeHandle, (Object)buildingHighlight);
        this.fetchBuildingInformation(nativeHandle);
    }

    @WorkerThread
    public int create(BuildingHighlightOptions buildingHighlightOptions, BuildingHighlight.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BuildingHighlight");
        }
        int selectionModeInt = buildingHighlightOptions.getSelectionMode().ordinal();
        LatLng location = buildingHighlightOptions.getSelectionLocation();
        Point screenPoint = buildingHighlightOptions.getSelectionScreenPoint();
        boolean shouldCreateView = buildingHighlightOptions.getShouldCreateView();
        return this.nativeCreateBuildingHighlight(this.m_jniEegeoMapApiPtr, selectionModeInt, location.latitude, location.longitude, screenPoint.x, screenPoint.y, buildingHighlightOptions.getColor(), shouldCreateView);
    }

    @WorkerThread
    public void destroy(BuildingHighlight buildingHighlight, BuildingHighlight.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BuildingHighlight");
        }
        int nativeHandle = buildingHighlight.getNativeHandle(allowHandleAccess);
        if (this.m_nativeHandleToBuildingHighlight.get(nativeHandle) != null) {
            this.nativeDestroyBuildingHighlight(this.m_jniEegeoMapApiPtr, nativeHandle);
            this.m_nativeHandleToBuildingHighlight.remove(nativeHandle);
        }
    }

    @WorkerThread
    void setStyleAttributes(int nativeHandle, BuildingHighlight.AllowHandleAccess allowHandleAccess, int colorARGB) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BuildingHighlight");
        }
        this.nativeSetStyleAttributes(this.m_jniEegeoMapApiPtr, nativeHandle, colorARGB);
    }

    @WorkerThread
    public void notifyBuildingInformationReceived(int nativeHandle) {
        if (this.m_nativeHandleToBuildingHighlight.get(nativeHandle) != null) {
            this.fetchBuildingInformation(nativeHandle);
        }
    }

    @WorkerThread
    private void fetchBuildingInformation(int nativeHandle) {
        final BuildingHighlight buildingHighlight = (BuildingHighlight)this.m_nativeHandleToBuildingHighlight.get(nativeHandle);
        if (buildingHighlight == null) {
            throw new NullPointerException("BuildingHighlight object not found for nativeHandle");
        }
        final BuildingInformation buildingInformation = this.nativeGetBuildingInformation(this.m_jniEegeoMapApiPtr, nativeHandle);
        if (buildingInformation != null) {
            this.m_uiRunner.runOnUiThread(new Runnable(){

                @Override
                @UiThread
                public void run() {
                    buildingHighlight.setBuildingInformation(buildingInformation);
                }
            });
        }
    }

    @WorkerThread
    private native int nativeCreateBuildingHighlight(long var1, int var3, double var4, double var6, int var8, int var9, int var10, boolean var11);

    @WorkerThread
    private native void nativeDestroyBuildingHighlight(long var1, int var3);

    @WorkerThread
    private native void nativeSetStyleAttributes(long var1, int var3, int var4);

    @WorkerThread
    private native BuildingInformation nativeGetBuildingInformation(long var1, int var3);
}

