/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.rendering;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.EegeoMap;
import com.eegeo.mapapi.rendering.RenderingApi;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class RenderingState
extends NativeApiObject {
    private final RenderingApi m_renderingApi;
    private final EegeoMap.AllowApiAccess m_allowApiAccess;
    private boolean m_isMapCollapsed;

    public RenderingState(final RenderingApi renderingApi, final EegeoMap.AllowApiAccess allowApiAccess, boolean isMapCollapsed) {
        super(renderingApi.getNativeRunner(), renderingApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return renderingApi.createNativeHandle(allowApiAccess);
            }
        });
        this.m_renderingApi = renderingApi;
        this.m_allowApiAccess = allowApiAccess;
        this.m_isMapCollapsed = isMapCollapsed;
        this.setMapCollapsed(isMapCollapsed);
    }

    @UiThread
    public boolean isMapCollapsed() {
        return this.m_isMapCollapsed;
    }

    @UiThread
    public void setMapCollapsed(final boolean isMapCollapsed) {
        this.m_isMapCollapsed = isMapCollapsed;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                RenderingState.this.m_renderingApi.setMapCollapsed(RenderingState.this.m_allowApiAccess, isMapCollapsed);
            }
        });
    }
}

