/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.indoors;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.annotation.UiThread;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.eegeo.indoors.BackwardsCompatibleListView;
import com.eegeo.indoors.IndoorFloorListAdapter;
import com.eegeo.mapapi.EegeoMap;
import com.eegeo.mapapi.MapView;
import com.eegeo.mapapi.R;
import com.eegeo.mapapi.indoors.IndoorMap;
import com.eegeo.mapapi.indoors.OnFloorChangedListener;
import com.eegeo.mapapi.indoors.OnIndoorEnteredListener;
import com.eegeo.mapapi.indoors.OnIndoorExitedListener;
import java.util.ArrayList;

public class IndoorMapView
implements OnIndoorEnteredListener,
OnIndoorExitedListener,
OnFloorChangedListener,
View.OnClickListener,
View.OnTouchListener {
    private final long m_stateChangeAnimationTimeMilliseconds = 200L;
    private final long m_stateChangeAnimationDelayMilliseconds = 1000L;
    private final long m_initialJumpThresholdPx = 5L;
    private final float ListItemHeight;
    private EegeoMap m_eegeoMap = null;
    private RelativeLayout m_uiContainer = null;
    private View m_uiRootView = null;
    private View m_topPanel = null;
    private View m_rightPanel = null;
    private ImageView m_backButton = null;
    private TextView m_floorNameView = null;
    private RelativeLayout m_floorButton = null;
    private TextView m_floorButtonText = null;
    private Boolean m_draggingFloorButton;
    private float m_topYPosActive;
    private float m_topYPosInactive;
    private RelativeLayout m_floorListContainer;
    private BackwardsCompatibleListView m_floorList;
    private int m_maxFloorsViewableCount = 5;
    private RelativeLayout m_floorLayout;
    private ImageView m_floorUpArrow;
    private ImageView m_floorDownArrow;
    private boolean m_isScrolling = false;
    private float m_scrollYCoordinate;
    private Handler m_scrollHandler;
    private Runnable m_scrollingRunnable;
    private float m_leftXPosActiveBackButton;
    private float m_leftXPosActiveFloorListContainer;
    private float m_leftXPosInactive;
    private IndoorFloorListAdapter m_floorListAdapter = null;
    private float m_previousYCoordinate;
    private boolean m_isButtonInitialJumpRemoved = false;
    private boolean m_isOnScreen = false;
    private IndoorMap m_indoorMap = null;
    private int m_currentFloorIndex = -1;
    private final int TextColorNormal = Color.parseColor((String)"#1256BE");
    private final int TextColorDown = Color.parseColor((String)"#CDFC0D");

    public IndoorMapView(MapView mapView, RelativeLayout uiContainer, EegeoMap eegeoMap) {
        this.m_eegeoMap = eegeoMap;
        this.m_uiContainer = uiContainer;
        LayoutInflater inflater = LayoutInflater.from((Context)this.m_uiContainer.getContext());
        this.m_uiRootView = inflater.inflate(R.layout.interiors_explorer_layout, (ViewGroup)this.m_uiContainer, false);
        this.ListItemHeight = this.m_uiRootView.getContext().getResources().getDimension(R.dimen.elevator_list_item_height);
        this.m_topPanel = this.m_uiRootView.findViewById(R.id.top_panel);
        this.m_rightPanel = this.m_uiRootView.findViewById(R.id.right_panel);
        this.m_backButton = (ImageView)this.m_uiRootView.findViewById(R.id.back_button);
        this.m_backButton.setOnClickListener((View.OnClickListener)this);
        this.m_floorNameView = (TextView)this.m_uiRootView.findViewById(R.id.floor_name);
        this.m_floorListContainer = (RelativeLayout)this.m_uiRootView.findViewById(R.id.interiors_floor_list_container);
        this.m_floorList = (BackwardsCompatibleListView)this.m_uiRootView.findViewById(R.id.interiors_floor_item_list);
        this.m_floorList.setOnTouchListener(new PropagateToViewTouchListener((View)mapView));
        this.m_floorList.setItemHeight(this.ListItemHeight);
        this.m_floorListAdapter = new IndoorFloorListAdapter(R.layout.interiors_floor_list_item);
        this.m_floorList.setAdapter((ListAdapter)this.m_floorListAdapter);
        this.m_floorLayout = (RelativeLayout)this.m_uiRootView.findViewById(R.id.interiors_floor_layout);
        this.m_floorUpArrow = (ImageView)this.m_uiRootView.findViewById(R.id.interiors_elevator_up_arrow);
        this.m_floorDownArrow = (ImageView)this.m_uiRootView.findViewById(R.id.interiors_elevator_down_arrow);
        this.m_floorButton = (RelativeLayout)this.m_uiRootView.findViewById(R.id.interiors_floor_list_button);
        this.m_floorButtonText = (TextView)this.m_uiRootView.findViewById(R.id.interiors_floor_list_button_text);
        this.m_floorButtonText.setTextColor(this.TextColorNormal);
        this.m_draggingFloorButton = false;
        this.m_floorButton.setOnTouchListener((View.OnTouchListener)this);
        this.m_uiRootView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                float screenWidth = IndoorMapView.this.m_uiContainer.getWidth();
                float controlWidth = IndoorMapView.this.m_topPanel.getWidth();
                float controlHeight = IndoorMapView.this.m_topPanel.getHeight();
                IndoorMapView.this.m_topYPosActive = IndoorMapView.this.m_uiRootView.getContext().getResources().getDimension(R.dimen.elevator_top_margin);
                IndoorMapView.this.m_topYPosInactive = -controlHeight;
                IndoorMapView.this.m_topPanel.setX(screenWidth * 0.5f - controlWidth * 0.5f);
                IndoorMapView.this.m_topPanel.setY(IndoorMapView.this.m_topYPosInactive);
                controlWidth = IndoorMapView.this.m_floorListContainer.getWidth();
                controlHeight = IndoorMapView.this.m_floorListContainer.getHeight();
                int menuButtonMarginPx = (int)IndoorMapView.this.m_uiRootView.getContext().getResources().getDimension(R.dimen.elevator_side_margin);
                IndoorMapView.this.m_leftXPosActiveBackButton = screenWidth - (float)(menuButtonMarginPx + IndoorMapView.this.m_backButton.getWidth());
                IndoorMapView.this.m_leftXPosActiveFloorListContainer = screenWidth - ((float)menuButtonMarginPx + controlWidth - (controlWidth - (float)IndoorMapView.this.m_backButton.getWidth()) / 2.0f);
                IndoorMapView.this.m_leftXPosInactive = screenWidth;
                IndoorMapView.this.m_floorListContainer.setX(IndoorMapView.this.m_leftXPosInactive);
                IndoorMapView.this.m_backButton.setX(IndoorMapView.this.m_leftXPosInactive);
                int screenHeight = IndoorMapView.this.m_uiContainer.getHeight();
                RelativeLayout.LayoutParams rightPanelLayoutParams = (RelativeLayout.LayoutParams)IndoorMapView.this.m_rightPanel.getLayoutParams();
                int rightPanelMarginTop = rightPanelLayoutParams.topMargin;
                int rightPanelMarginBottom = rightPanelLayoutParams.bottomMargin;
                RelativeLayout.LayoutParams floorListContainerLayoutParams = (RelativeLayout.LayoutParams)IndoorMapView.this.m_floorListContainer.getLayoutParams();
                int floorListMarginTop = floorListContainerLayoutParams.topMargin;
                int maxFloorContainerHeight = screenHeight - rightPanelMarginTop - IndoorMapView.this.m_backButton.getHeight() - floorListMarginTop - rightPanelMarginBottom;
                IndoorMapView.this.m_maxFloorsViewableCount = (int)Math.floor((float)maxFloorContainerHeight / IndoorMapView.this.ListItemHeight);
            }
        });
        this.m_uiContainer.addView(this.m_uiRootView);
        this.m_uiRootView.setVisibility(0);
        this.hideFloorLabels();
        this.m_eegeoMap.addOnIndoorEnteredListener(this);
        this.m_eegeoMap.addOnIndoorExitedListener(this);
        this.m_eegeoMap.addOnFloorChangedListener(this);
        this.m_scrollHandler = new Handler();
        this.m_scrollingRunnable = new Runnable(){

            @Override
            public void run() {
                IndoorMapView.this.scrollingUpdate();
                IndoorMapView.this.m_scrollHandler.postDelayed(IndoorMapView.this.m_scrollingRunnable, 1L);
            }
        };
        this.forceViewRelayout((View)mapView);
    }

    @Override
    @UiThread
    public void onIndoorEntered() {
        this.m_indoorMap = this.m_eegeoMap.getActiveIndoorMap();
        this.m_currentFloorIndex = this.m_eegeoMap.getCurrentFloorIndex();
        this.updateFloors(this.m_indoorMap.floorIds, this.m_currentFloorIndex);
        this.setFloorName(this.m_indoorMap.floorNames[this.m_currentFloorIndex]);
        this.setSelectedFloorIndex(this.m_currentFloorIndex);
        this.m_uiRootView.setVisibility(0);
        this.forceViewRelayout(this.m_uiRootView);
        this.animateToActive();
    }

    @Override
    public void onIndoorExited() {
        this.m_uiRootView.setVisibility(4);
    }

    @Override
    public void onFloorChanged(int selectedFloor) {
        this.m_currentFloorIndex = selectedFloor;
        this.setFloorName(this.m_indoorMap.floorNames[this.m_currentFloorIndex]);
        this.setSelectedFloorIndex(this.m_currentFloorIndex);
    }

    private int getListViewHeight(ListView list) {
        return list.getCount() * (int)this.ListItemHeight;
    }

    private int getListViewHeight(int listCount) {
        return listCount * (int)this.ListItemHeight;
    }

    public void destroy() {
        this.m_uiContainer.removeView(this.m_uiRootView);
        this.m_uiRootView = null;
        this.m_scrollHandler.removeCallbacks(this.m_scrollingRunnable);
    }

    public void updateFloors(String[] floorShortNames, int currentlySelectedFloorIndex) {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = floorShortNames.length - 1; i >= 0; --i) {
            temp.add(floorShortNames[i]);
        }
        this.m_floorListAdapter.setData(temp);
        float controlHeight = this.getListViewHeight(Math.min(this.m_floorList.getCount(), this.m_maxFloorsViewableCount));
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.m_floorListContainer.getLayoutParams();
        layoutParams.height = (int)controlHeight;
        this.m_floorListContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.refreshFloorIndicator(currentlySelectedFloorIndex);
        this.moveButtonToFloorIndex(currentlySelectedFloorIndex, false);
        boolean floorSelectionEnabled = floorShortNames.length > 1;
        this.m_floorListContainer.setVisibility(floorSelectionEnabled ? 0 : 8);
        this.m_floorUpArrow.setY(this.m_floorList.getY());
        this.m_floorDownArrow.setY(this.m_floorList.getY() + controlHeight - (float)this.m_floorDownArrow.getHeight());
    }

    private void setArrowState(boolean showUp, boolean showDown) {
        this.m_floorUpArrow.setVisibility(showUp ? 0 : 4);
        this.m_floorDownArrow.setVisibility(showDown ? 0 : 4);
    }

    private void moveButtonToFloorIndex(int floorIndex, Boolean shouldAnimate) {
        int halfMaxFloorsViewableCount;
        int startFloorIndex;
        int floorCount = this.m_floorListAdapter.getCount();
        if (floorCount - (startFloorIndex = floorCount - floorIndex) >= (halfMaxFloorsViewableCount = (int)Math.ceil((float)this.m_maxFloorsViewableCount / 2.0f))) {
            startFloorIndex = Math.max(startFloorIndex - halfMaxFloorsViewableCount, 0);
        }
        int screenFloorIndex = floorCount - 1 - floorIndex;
        if (floorCount > this.m_maxFloorsViewableCount) {
            startFloorIndex = Math.min(startFloorIndex, floorCount - this.m_maxFloorsViewableCount);
            screenFloorIndex = floorCount - 1 - floorIndex - startFloorIndex;
        }
        float topY = this.m_floorList.getY() + this.ListItemHeight * 0.5f - (float)this.m_floorButton.getWidth() * 0.5f;
        float newY = topY + (float)screenFloorIndex * this.ListItemHeight;
        newY = Math.max(0.0f, Math.min((float)this.getListViewHeight(this.m_floorList), newY));
        if (shouldAnimate.booleanValue()) {
            this.m_floorButton.animate().y(newY).setDuration(200L).start();
            this.m_floorList.smoothScrollToPositionFromTop(startFloorIndex, 0);
        } else {
            this.m_floorButton.setY(newY);
            this.m_floorList.setSelection(startFloorIndex);
        }
        if (floorCount > this.m_maxFloorsViewableCount) {
            this.setArrowState(floorCount - floorIndex > halfMaxFloorsViewableCount, floorCount - startFloorIndex > this.m_maxFloorsViewableCount);
        } else {
            this.setArrowState(false, false);
        }
    }

    public void setFloorName(String name) {
        this.m_floorNameView.setText((CharSequence)name);
    }

    public void setSelectedFloorIndex(int index) {
        this.refreshFloorIndicator(index);
        if (!this.m_draggingFloorButton.booleanValue()) {
            this.moveButtonToFloorIndex(index, true);
        }
    }

    public boolean onTouch(View view, MotionEvent event) {
        if (view == this.m_floorButton) {
            if (event.getAction() == 0) {
                this.startDraggingButton(event.getRawY());
            } else if (event.getAction() == 2) {
                this.updateDraggingButton(event.getRawY());
            } else if (event.getAction() == 1) {
                this.endDraggingButton();
            }
            return true;
        }
        return false;
    }

    private void startDraggingButton(float initialYCoordinate) {
        this.showFloorLabels();
        this.m_floorButton.getBackground().setState(new int[]{16842919});
        this.m_floorButtonText.setTextColor(this.TextColorDown);
        this.m_previousYCoordinate = initialYCoordinate;
        this.m_draggingFloorButton = true;
        this.m_isButtonInitialJumpRemoved = false;
        this.m_eegeoMap.expandIndoor();
        this.startScrollingUpdate();
    }

    private void updateDraggingButton(float yCoordinate) {
        this.m_scrollYCoordinate = yCoordinate;
        if (!this.m_isButtonInitialJumpRemoved) {
            this.detectAndRemoveInitialJump(this.m_scrollYCoordinate);
        }
    }

    private void endDraggingButton() {
        this.endScrollingUpdate();
        this.hideFloorLabels();
        this.m_draggingFloorButton = false;
        this.m_floorButton.getBackground().setState(new int[0]);
        this.m_floorButtonText.setTextColor(this.TextColorNormal);
        View firstVisibleChild = this.m_floorList.getChildAt(0);
        float topY = (float)this.m_floorList.getFirstVisiblePosition() * this.ListItemHeight - (float)firstVisibleChild.getTop();
        float dragParameter = 1.0f - (topY + this.m_floorButton.getY()) / (float)this.getListViewHeight(this.m_floorList.getCount() - 1);
        int floorCount = this.m_floorListAdapter.getCount() - 1;
        int selectedFloor = Math.round(dragParameter * (float)floorCount);
        this.moveButtonToFloorIndex(selectedFloor, true);
        this.m_eegeoMap.collapseIndoor();
        this.m_eegeoMap.setIndoorFloor(selectedFloor);
    }

    private float getScrollSpeed(float t) {
        float maxScrollSpeed = this.m_uiRootView.getContext().getResources().getDimension(R.dimen.elevator_max_scroll_speed);
        t = Math.max(-1.0f, Math.min(1.0f, t));
        return t * Math.abs(t) * maxScrollSpeed;
    }

    private void detectAndRemoveInitialJump(float yCoordinate) {
        float y = yCoordinate;
        float deltaY = y - this.m_previousYCoordinate;
        if (Math.abs(deltaY) > 5.0f) {
            this.m_previousYCoordinate += deltaY;
            this.m_isButtonInitialJumpRemoved = true;
        }
    }

    public void onClick(View view) {
        if (view == this.m_backButton) {
            this.animateToInactive();
            this.m_uiRootView.setVisibility(4);
            this.m_eegeoMap.onExitIndoorClicked();
        }
    }

    public void animateToActive() {
        this.m_isOnScreen = true;
        this.animateViewToY((int)this.m_topYPosActive);
        this.animateViewToX((int)this.m_leftXPosActiveBackButton, (int)this.m_leftXPosActiveFloorListContainer, this.m_isOnScreen);
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                int[] rootViewPosition = new int[]{0, 0};
                IndoorMapView.this.m_uiRootView.getLocationInWindow(rootViewPosition);
                int[] backButtonPosition = new int[]{0, 0};
                IndoorMapView.this.m_backButton.getLocationInWindow(backButtonPosition);
                int[] floorButtonPosition = new int[]{0, 0};
                IndoorMapView.this.m_floorButton.getLocationInWindow(floorButtonPosition);
            }
        }, 200L + (this.m_isOnScreen ? 1000L : 0L));
    }

    public void animateToInactive() {
        this.endScrollingUpdate();
        this.m_isOnScreen = false;
        this.animateViewToY((int)this.m_topYPosInactive);
        this.animateViewToX((int)this.m_leftXPosInactive, (int)this.m_leftXPosInactive, this.m_isOnScreen);
    }

    protected void animateViewToY(int yAsPx) {
        this.m_topPanel.animate().y((float)yAsPx).setDuration(200L);
    }

    protected void animateViewToX(int xAsPxBackButton, int xAsPxFloorListContainer, boolean addDelay) {
        long delay = addDelay ? 1000L : 0L;
        this.m_floorListContainer.animate().x((float)xAsPxFloorListContainer).setDuration(200L).setStartDelay(delay);
        this.m_backButton.animate().x((float)xAsPxBackButton).setDuration(200L).setStartDelay(delay);
    }

    public void notifyOnPause() {
        this.endScrollingUpdate();
    }

    private void refreshFloorIndicator(int floorIndex) {
        int nameIndex = this.m_floorListAdapter.getCount() - 1 - floorIndex;
        this.m_floorButtonText.setText((CharSequence)((String)this.m_floorListAdapter.getItem(nameIndex)));
    }

    private void hideFloorLabels() {
        this.m_floorLayout.animate().alpha(0.5f).setDuration(200L);
    }

    private void showFloorLabels() {
        this.m_floorLayout.animate().alpha(1.0f).setDuration(200L);
    }

    private void startScrollingUpdate() {
        if (!this.m_isScrolling) {
            this.m_previousYCoordinate = this.m_scrollYCoordinate;
            this.m_scrollingRunnable.run();
        }
        this.m_isScrolling = true;
    }

    private void scrollingUpdate() {
        if (this.m_isScrolling) {
            float localT;
            float joystickScrollThresholdDistance = 0.25f;
            if (!this.m_isButtonInitialJumpRemoved) {
                this.detectAndRemoveInitialJump(this.m_scrollYCoordinate);
            }
            float newY = this.m_floorButton.getY() + (this.m_scrollYCoordinate - this.m_previousYCoordinate);
            newY = Math.max(0.0f, Math.min((float)Math.min(this.getListViewHeight(this.m_maxFloorsViewableCount - 1), this.getListViewHeight(this.m_floorList.getCount() - 1)), newY));
            this.m_floorButton.setY(newY);
            this.m_previousYCoordinate = this.m_scrollYCoordinate;
            float scrollDelta = 0.0f;
            float listViewHeightOnScreen = this.getListViewHeight(this.m_maxFloorsViewableCount - 1);
            float normalisedNewY = newY / listViewHeightOnScreen;
            if (normalisedNewY <= 0.25f) {
                localT = normalisedNewY / 0.25f;
                scrollDelta = this.getScrollSpeed(1.0f - localT);
            } else if (normalisedNewY >= 0.75f) {
                localT = (normalisedNewY - 0.75f) / 0.25f;
                scrollDelta = this.getScrollSpeed(-localT);
            }
            this.m_floorList.scrollListBy_compat(-Math.round(scrollDelta));
            View firstVisibleChild = this.m_floorList.getChildAt(0);
            float topY = (float)this.m_floorList.getFirstVisiblePosition() * this.ListItemHeight - (float)firstVisibleChild.getTop();
            float dragParameter = 1.0f - (topY + newY) / (float)this.getListViewHeight(this.m_floorList.getCount() - 1);
            float floorParam = dragParameter * (float)(this.m_floorList.getCount() - 1);
            this.m_eegeoMap.setIndoorFloorInterpolation(floorParam);
            int nearestFloorIndex = Math.round(floorParam);
            this.setFloorName(this.m_indoorMap.floorNames[nearestFloorIndex]);
            this.refreshFloorIndicator(nearestFloorIndex);
            int floorCount = this.m_floorList.getCount();
            if (floorCount > this.m_maxFloorsViewableCount) {
                int firstFloorVisibleInView = this.m_floorList.getFirstVisiblePosition();
                boolean showUp = firstFloorVisibleInView > 0 || (float)firstVisibleChild.getTop() < -(this.ListItemHeight * 0.5f);
                boolean showDown = floorCount - firstFloorVisibleInView - (firstVisibleChild.getTop() < 0 ? 1 : 0) > this.m_maxFloorsViewableCount;
                this.setArrowState(showUp, showDown);
            }
        }
    }

    private void endScrollingUpdate() {
        this.m_isScrolling = false;
        this.m_scrollHandler.removeCallbacks(this.m_scrollingRunnable);
    }

    @UiThread
    private void forceViewRelayout(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000));
        view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
    }

    private class PropagateToViewTouchListener
    implements View.OnTouchListener {
        private View m_target;

        PropagateToViewTouchListener(View target) {
            this.m_target = target;
        }

        public boolean onTouch(View view, MotionEvent event) {
            return this.m_target.onTouchEvent(event);
        }
    }
}

