/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.routing;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.services.routing.RoutingQuery;
import com.eegeo.mapapi.services.routing.RoutingQueryOptions;
import com.eegeo.mapapi.services.routing.RoutingQueryResponse;
import java.util.List;

public class RoutingApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<RoutingQuery> m_nativeHandleToRoutingQuery = new SparseArray();

    public RoutingApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @WorkerThread
    int beginRouteQuery(RoutingQueryOptions options) {
        List<RoutingQueryOptions.Waypoint> waypoints = options.getWaypoints();
        int count = waypoints.size();
        double[] latitudes = new double[count];
        double[] longitudes = new double[count];
        boolean[] isIndoors = new boolean[count];
        int[] indoorFloorIds = new int[count];
        for (int i = 0; i < count; ++i) {
            latitudes[i] = waypoints.get((int)i).latLng.latitude;
            longitudes[i] = waypoints.get((int)i).latLng.longitude;
            isIndoors[i] = waypoints.get((int)i).isIndoors;
            indoorFloorIds[i] = waypoints.get((int)i).indoorFloorId;
        }
        return this.nativeBeginRoutingQuery(this.m_jniEegeoMapApiPtr, count, latitudes, longitudes, isIndoors, indoorFloorIds);
    }

    @WorkerThread
    void cancelQuery(int nativeHandle) {
        this.nativeCancelRoutingQuery(this.m_jniEegeoMapApiPtr, nativeHandle);
        this.m_nativeHandleToRoutingQuery.remove(nativeHandle);
    }

    @WorkerThread
    void register(RoutingQuery routingQuery, int nativeHandle) {
        this.m_nativeHandleToRoutingQuery.put(nativeHandle, (Object)routingQuery);
    }

    @WorkerThread
    void unregister(int nativeHandle) {
        this.m_nativeHandleToRoutingQuery.remove(nativeHandle);
    }

    @WorkerThread
    public void notifyQueryComplete(int routingQueryId, RoutingQueryResponse response) {
        if (this.m_nativeHandleToRoutingQuery.get(routingQueryId) != null) {
            this.returnQueryResponse(routingQueryId, response);
        }
    }

    @WorkerThread
    void returnQueryResponse(int nativeHandle, final RoutingQueryResponse response) {
        final RoutingQuery routingQuery = (RoutingQuery)this.m_nativeHandleToRoutingQuery.get(nativeHandle);
        if (routingQuery == null) {
            throw new NullPointerException("RoutingQuery object not found for nativeHandle");
        }
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                routingQuery.returnQueryResponse(response);
            }
        });
        this.m_nativeHandleToRoutingQuery.remove(nativeHandle);
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    private native int nativeBeginRoutingQuery(long var1, int var3, double[] var4, double[] var5, boolean[] var6, int[] var7);

    @WorkerThread
    private native void nativeCancelRoutingQuery(long var1, int var3);
}

