/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.positioner;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.LatLngAlt;
import com.eegeo.mapapi.positioner.PositionerApi;
import com.eegeo.mapapi.positioner.PositionerOptions;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class Positioner
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final PositionerApi m_positionerApi;
    private String m_indoorMapId;
    private int m_indoorMapFloorId;
    private LatLng m_position;
    private double m_elevation;
    private ElevationMode m_elevationMode;
    private Point m_screenPoint = new Point();
    private LatLngAlt m_transformedPoint = new LatLngAlt(0.0, 0.0, 0.0);
    private boolean m_isScreenPointValid = false;
    private boolean m_isTransformedPointValid = false;
    private boolean m_isBehindGlobeHorizon = false;

    @UiThread
    public Positioner(final @NonNull PositionerApi positionerApi, final @NonNull PositionerOptions positionerOptions) {
        super(positionerApi.getNativeRunner(), positionerApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return positionerApi.createPositioner(positionerOptions, m_allowHandleAccess);
            }
        });
        this.m_positionerApi = positionerApi;
        this.m_position = positionerOptions.getPosition();
        this.m_elevation = positionerOptions.getElevation();
        this.m_elevationMode = positionerOptions.getElevationMode();
        this.m_indoorMapId = positionerOptions.getIndoorMapId();
        this.m_indoorMapFloorId = positionerOptions.getIndoorMapFloorId();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                positionerApi.registerPositioner(Positioner.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public LatLng getPosition() {
        return this.m_position;
    }

    @UiThread
    public void setPosition(@NonNull LatLng position) {
        this.m_position = position;
        this.updateLocation();
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateLocation();
    }

    @UiThread
    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    @UiThread
    public void setElevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        this.updateLocation();
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public void setIndoorMapId(String indoorMapId) {
        this.m_indoorMapId = indoorMapId;
        this.updateLocation();
    }

    @UiThread
    public int getIndoorMapFloorId() {
        return this.m_indoorMapFloorId;
    }

    @UiThread
    public void setIndoorMapFloorId(int indoorMapFloorId) {
        this.m_indoorMapFloorId = indoorMapFloorId;
        this.updateLocation();
    }

    @UiThread
    @Nullable
    public Point getScreenPointOrNull() {
        return this.m_isScreenPointValid ? this.m_screenPoint : null;
    }

    @UiThread
    @Nullable
    public LatLngAlt getTransformedPointOrNull() {
        return this.m_isTransformedPointValid ? this.m_transformedPoint : null;
    }

    @UiThread
    public boolean isBehindGlobeHorizon() {
        return this.m_isBehindGlobeHorizon;
    }

    @UiThread
    public boolean isScreenPointProjectionDefined() {
        return this.m_isScreenPointValid && !this.m_isBehindGlobeHorizon;
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Positioner.this.m_positionerApi.destroy(Positioner.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    private void updateLocation() {
        final LatLng position = this.m_position;
        final double elevation = this.m_elevation;
        final ElevationMode elevationMode = this.m_elevationMode;
        final String indoorMapId = this.m_indoorMapId;
        final int indoorFloorId = this.m_indoorMapFloorId;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Positioner.this.m_positionerApi.updateLocation(Positioner.this.getNativeHandle(), m_allowHandleAccess, position, elevation, elevationMode, indoorMapId, indoorFloorId);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by PositionerApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    @UiThread
    void setProjectedState(Point screenPoint, LatLngAlt transformedPoint, boolean isBehindGlobeHorizon) {
        boolean isTransformedPointValid;
        boolean changed = false;
        boolean isScreenPointValid = screenPoint != null;
        boolean bl = isTransformedPointValid = transformedPoint != null;
        if (isScreenPointValid != this.m_isScreenPointValid) {
            this.m_isScreenPointValid = isScreenPointValid;
            changed = true;
        }
        if (isScreenPointValid && !this.m_screenPoint.equals((Object)screenPoint)) {
            this.m_screenPoint.set(screenPoint.x, screenPoint.y);
            changed = true;
        }
        if (isTransformedPointValid != this.m_isTransformedPointValid) {
            this.m_isTransformedPointValid = isTransformedPointValid;
            changed = true;
        }
        if (isTransformedPointValid && !this.m_transformedPoint.equals(transformedPoint)) {
            this.m_transformedPoint = transformedPoint;
            changed = true;
        }
        if (this.m_isBehindGlobeHorizon != isBehindGlobeHorizon) {
            this.m_isBehindGlobeHorizon = isBehindGlobeHorizon;
            changed = true;
        }
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

