/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.markers;

import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;

public final class MarkerOptions {
    private LatLng m_position;
    private double m_elevation;
    private ElevationMode m_elevationMode = ElevationMode.HeightAboveGround;
    private int m_drawOrder;
    private String m_title = "";
    private String m_styleName = "marker_default";
    private String m_userData = "";
    private String m_iconKey = "pin";
    private String m_indoorMapId = "";
    private int m_indoorFloorId;

    public MarkerOptions position(LatLng position) {
        this.m_position = position;
        return this;
    }

    public MarkerOptions elevation(double elevation) {
        this.m_elevation = elevation;
        return this;
    }

    public MarkerOptions elevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        return this;
    }

    public MarkerOptions elevationMode(MarkerElevationMode markerElevationMode) {
        this.m_elevationMode = MarkerOptions.fromMarkerElevationMode(markerElevationMode);
        return this;
    }

    public MarkerOptions labelText(String title) {
        this.m_title = title;
        return this;
    }

    public MarkerOptions styleName(String styleName) {
        this.m_styleName = styleName;
        return this;
    }

    public MarkerOptions userData(String userData) {
        this.m_userData = userData;
        return this;
    }

    public MarkerOptions iconKey(String iconKey) {
        this.m_iconKey = iconKey;
        return this;
    }

    public MarkerOptions indoor(String indoorMapId, int indoorFloorId) {
        this.m_indoorMapId = indoorMapId;
        this.m_indoorFloorId = indoorFloorId;
        return this;
    }

    public MarkerOptions drawOrder(int drawOrder) {
        this.m_drawOrder = drawOrder;
        return this;
    }

    public LatLng getPosition() {
        return this.m_position;
    }

    public double getElevation() {
        return this.m_elevation;
    }

    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getDrawOrder() {
        return this.m_drawOrder;
    }

    public String getStyleName() {
        return this.m_styleName;
    }

    public String getUserData() {
        return this.m_userData;
    }

    public String getIconKey() {
        return this.m_iconKey;
    }

    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    public static ElevationMode fromMarkerElevationMode(MarkerElevationMode markerElevationMode) {
        if (markerElevationMode == MarkerElevationMode.HeightAboveGround) {
            return ElevationMode.HeightAboveGround;
        }
        return ElevationMode.HeightAboveSeaLevel;
    }

    public static MarkerElevationMode toMarkerElevationMode(ElevationMode elevationMode) {
        if (elevationMode == ElevationMode.HeightAboveGround) {
            return MarkerElevationMode.HeightAboveGround;
        }
        return MarkerElevationMode.HeightAboveSeaLevel;
    }

    public static enum MarkerElevationMode {
        HeightAboveSeaLevel,
        HeightAboveGround;

    }
}

