/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.ui.nativeinput;

import android.app.Activity;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

public class KeyboardInput {
    private static InputMethodManager m_inputManager;
    private static View m_targetView;

    public static void dismiss() {
        m_inputManager.hideSoftInputFromWindow(m_targetView.getWindowToken(), 0);
    }

    public static void showKeyboard(final Activity a, int keyboardType, int returnKeyType, long ptr) {
        Log.v((String)"ShowKeyboard", (String)("Keyboard Type: " + keyboardType + ", Return Key Type: " + returnKeyType));
        a.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    m_targetView = a.getWindow().getDecorView().getRootView();
                    Log.v((String)"ShowKeyboard", (String)"Forcing SoftInput Display");
                    m_inputManager = (InputMethodManager)a.getSystemService("input_method");
                    m_inputManager.showSoftInput(m_targetView, 2);
                }
                catch (Exception e) {
                    Log.v((String)"KeyboardInput", (String)(e.getMessage() == null ? "Error, but no message?!" : e.getMessage()));
                }
            }
        });
    }
}

