/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.poi;

import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.services.poi.OnPoiSearchCompletedListener;

public final class TextSearchOptions {
    private String m_query;
    private LatLng m_center;
    private boolean m_useRadius = false;
    private double m_radius = 0.0;
    private boolean m_useNumber = false;
    private int m_number = 0;
    private boolean m_useMinScore = false;
    private double m_minScore = 0.0;
    private boolean m_useIndoorId = false;
    private String m_indoorId = "";
    private boolean m_useFloorNumber = false;
    private int m_floorNumber = 0;
    private boolean m_useFloorDropoff = false;
    private int m_floorDropoff = 0;
    private OnPoiSearchCompletedListener m_onPoiSearchCompletedListener = null;

    public TextSearchOptions(String query, LatLng center) {
        this.m_query = query;
        this.m_center = center;
    }

    public TextSearchOptions radius(double radius) {
        this.m_radius = radius;
        this.m_useRadius = true;
        return this;
    }

    public TextSearchOptions number(int number) {
        this.m_number = number;
        this.m_useNumber = true;
        return this;
    }

    public TextSearchOptions minScore(double minScore) {
        this.m_minScore = minScore;
        this.m_useMinScore = true;
        return this;
    }

    public TextSearchOptions indoorId(String indoorId) {
        this.m_indoorId = indoorId;
        this.m_useIndoorId = true;
        return this;
    }

    public TextSearchOptions floorNumber(int floorNumber) {
        this.m_floorNumber = floorNumber;
        this.m_useFloorNumber = true;
        return this;
    }

    public TextSearchOptions floorDropoff(int floorDropoff) {
        this.m_floorDropoff = floorDropoff;
        this.m_useFloorDropoff = true;
        return this;
    }

    public TextSearchOptions onPoiSearchCompletedListener(OnPoiSearchCompletedListener onPoiSearchCompletedListener) {
        this.m_onPoiSearchCompletedListener = onPoiSearchCompletedListener;
        return this;
    }

    String getQuery() {
        return this.m_query;
    }

    LatLng getCenter() {
        return this.m_center;
    }

    double getRadius() {
        return this.m_radius;
    }

    int getNumber() {
        return this.m_number;
    }

    double getMinScore() {
        return this.m_minScore;
    }

    String getIndoorId() {
        return this.m_indoorId;
    }

    int getFloorNumber() {
        return this.m_floorNumber;
    }

    int getFloorDropoff() {
        return this.m_floorDropoff;
    }

    OnPoiSearchCompletedListener getOnPoiSearchCompletedListener() {
        return this.m_onPoiSearchCompletedListener;
    }

    boolean usesRadius() {
        return this.m_useRadius;
    }

    boolean usesNumber() {
        return this.m_useNumber;
    }

    boolean usesMinScore() {
        return this.m_useMinScore;
    }

    boolean usesIndoorId() {
        return this.m_useIndoorId;
    }

    boolean usesFloorNumber() {
        return this.m_useFloorNumber;
    }

    boolean usesFloorDropoff() {
        return this.m_useFloorDropoff;
    }
}

