/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.poi;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.services.poi.AutocompleteOptions;
import com.eegeo.mapapi.services.poi.PoiSearch;
import com.eegeo.mapapi.services.poi.PoiSearchResponse;
import com.eegeo.mapapi.services.poi.PoiSearchResult;
import com.eegeo.mapapi.services.poi.TagSearchOptions;
import com.eegeo.mapapi.services.poi.TextSearchOptions;
import java.util.List;
import java.util.concurrent.Callable;

public class PoiApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<PoiSearch> m_nativeHandleToPoiSearch = new SparseArray();

    public PoiApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public PoiSearch searchText(final TextSearchOptions options) {
        PoiSearch search = new PoiSearch(this, options.getOnPoiSearchCompletedListener(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return PoiApi.this.beginTextSearch(options);
            }
        });
        return search;
    }

    @UiThread
    public PoiSearch searchTag(final TagSearchOptions options) {
        PoiSearch search = new PoiSearch(this, options.getOnPoiSearchCompletedListener(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return PoiApi.this.beginTagSearch(options);
            }
        });
        return search;
    }

    @UiThread
    public PoiSearch searchAutocomplete(final AutocompleteOptions options) {
        PoiSearch search = new PoiSearch(this, options.getOnPoiSearchCompletedListener(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return PoiApi.this.beginAutocompleteSearch(options);
            }
        });
        return search;
    }

    @WorkerThread
    void register(PoiSearch poiSearch, int nativeHandle) {
        this.m_nativeHandleToPoiSearch.put(nativeHandle, (Object)poiSearch);
    }

    @WorkerThread
    void unregister(int nativeHandle) {
        this.m_nativeHandleToPoiSearch.remove(nativeHandle);
    }

    @WorkerThread
    public void notifySearchComplete(int nativeHandle, boolean succeeded, List<PoiSearchResult> searchResults) {
        PoiSearchResponse result = new PoiSearchResponse(succeeded, searchResults);
        if (this.m_nativeHandleToPoiSearch.get(nativeHandle) != null) {
            this.returnSearchResults(nativeHandle, result);
        }
    }

    @WorkerThread
    void returnSearchResults(int nativeHandle, PoiSearchResponse searchResults) {
        PoiSearch poiSearch = (PoiSearch)this.m_nativeHandleToPoiSearch.get(nativeHandle);
        if (poiSearch == null) {
            throw new NullPointerException("PoiSearch object not found for nativeHandle");
        }
        poiSearch.returnSearchResults(searchResults);
        this.m_nativeHandleToPoiSearch.remove(nativeHandle);
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    int beginTextSearch(TextSearchOptions options) {
        return this.nativeBeginTextSearch(this.m_jniEegeoMapApiPtr, options.getQuery(), options.getCenter().latitude, options.getCenter().longitude, options.usesRadius(), options.getRadius(), options.usesNumber(), options.getNumber(), options.usesMinScore(), options.getMinScore(), options.usesIndoorId(), options.getIndoorId(), options.usesFloorNumber(), options.getFloorNumber(), options.usesFloorDropoff(), options.getFloorDropoff());
    }

    @WorkerThread
    int beginTagSearch(TagSearchOptions options) {
        return this.nativeBeginTagSearch(this.m_jniEegeoMapApiPtr, options.getQuery(), options.getCenter().latitude, options.getCenter().longitude, options.usesRadius(), options.getRadius(), options.usesNumber(), options.getNumber());
    }

    @WorkerThread
    int beginAutocompleteSearch(AutocompleteOptions options) {
        return this.nativeBeginAutocompleteSearch(this.m_jniEegeoMapApiPtr, options.getQuery(), options.getCenter().latitude, options.getCenter().longitude, options.usesNumber(), options.getNumber());
    }

    @WorkerThread
    void cancelSearch(int searchNativeHandle) {
        this.nativeCancelSearch(this.m_jniEegeoMapApiPtr, searchNativeHandle);
        this.m_nativeHandleToPoiSearch.remove(searchNativeHandle);
    }

    private native int nativeBeginTextSearch(long var1, String var3, double var4, double var6, boolean var8, double var9, boolean var11, int var12, boolean var13, double var14, boolean var16, String var17, boolean var18, int var19, boolean var20, int var21);

    private native int nativeBeginTagSearch(long var1, String var3, double var4, double var6, boolean var8, double var9, boolean var11, int var12);

    private native int nativeBeginAutocompleteSearch(long var1, String var3, double var4, double var6, boolean var8, int var9);

    private native void nativeCancelSearch(long var1, int var3);
}

