/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.positioner;

import android.graphics.Point;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.LatLngAlt;
import com.eegeo.mapapi.positioner.OnPositionerChangedListener;
import com.eegeo.mapapi.positioner.Positioner;
import com.eegeo.mapapi.positioner.PositionerOptions;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class PositionerApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private ArrayList<OnPositionerChangedListener> m_onPositionerChangedListeners = new ArrayList();
    private SparseArray<Positioner> m_nativeHandleToPositioner = new SparseArray();

    public PositionerApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    public IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @UiThread
    public void addPositionerChangedListener(OnPositionerChangedListener listener) {
        this.m_onPositionerChangedListeners.add(listener);
    }

    @UiThread
    public void removePositionerChangedListener(OnPositionerChangedListener listener) {
        this.m_onPositionerChangedListeners.remove(listener);
    }

    @WorkerThread
    void registerPositioner(Positioner positioner, Positioner.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToPositioner.put(positioner.getNativeHandle(allowHandleAccess), (Object)positioner);
    }

    @WorkerThread
    void unregisterPositioner(Positioner positioner, Positioner.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToPositioner.remove(positioner.getNativeHandle(allowHandleAccess));
    }

    @WorkerThread
    int createPositioner(PositionerOptions positionerOptions, Positioner.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Positioner");
        }
        LatLng location = positionerOptions.getPosition();
        if (location == null) {
            throw new InvalidParameterException("PositionerOptions position must be set");
        }
        return this.nativeCreatePositioner(this.m_jniEegeoMapApiPtr, location.latitude, location.longitude, positionerOptions.getElevation(), positionerOptions.getElevationMode().ordinal(), positionerOptions.getIndoorMapId(), positionerOptions.getIndoorMapFloorId());
    }

    @WorkerThread
    public void destroy(Positioner positioner, Positioner.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Positioner");
        }
        this.nativeDestroyPositioner(this.m_jniEegeoMapApiPtr, positioner.getNativeHandle(allowHandleAccess));
    }

    @WorkerThread
    void updateLocation(int positionerNativeHandle, Positioner.AllowHandleAccess allowHandleAccess, LatLng position, double elevation, ElevationMode elevationMode, String indoorMapId, int indoorFloorId) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Positioner");
        }
        this.nativeUpdateLocation(this.m_jniEegeoMapApiPtr, positionerNativeHandle, position.latitude, position.longitude, elevation, elevationMode.ordinal(), indoorMapId, indoorFloorId);
    }

    @WorkerThread
    public void notifyProjectionChanged() {
        for (int i = 0; i < this.m_nativeHandleToPositioner.size(); ++i) {
            int positionerNativeHandle = this.m_nativeHandleToPositioner.keyAt(i);
            final Point screenPoint = this.nativeGetScreenPoint(this.m_jniEegeoMapApiPtr, positionerNativeHandle);
            final LatLngAlt transformedPoint = this.nativeGetTransformedPoint(this.m_jniEegeoMapApiPtr, positionerNativeHandle);
            final Boolean isBehindGlobeHorizon = this.nativeGetIsBehindGlobeHorizon(this.m_jniEegeoMapApiPtr, positionerNativeHandle);
            final Positioner positioner = (Positioner)this.m_nativeHandleToPositioner.get(positionerNativeHandle);
            this.m_uiRunner.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    positioner.setProjectedState(screenPoint, transformedPoint, isBehindGlobeHorizon);
                    for (OnPositionerChangedListener listener : PositionerApi.this.m_onPositionerChangedListeners) {
                        listener.onPositionerChanged(positioner);
                    }
                }
            });
        }
    }

    @WorkerThread
    private native int nativeCreatePositioner(long var1, double var3, double var5, double var7, int var9, String var10, int var11);

    @WorkerThread
    private native void nativeDestroyPositioner(long var1, int var3);

    @WorkerThread
    private native void nativeUpdateLocation(long var1, int var3, double var4, double var6, double var8, int var10, String var11, int var12);

    @WorkerThread
    private native Point nativeGetScreenPoint(long var1, int var3);

    @WorkerThread
    private native LatLngAlt nativeGetTransformedPoint(long var1, int var3);

    @WorkerThread
    private native boolean nativeGetIsBehindGlobeHorizon(long var1, int var3);
}

