/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.polygons;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.polygons.Polygon;
import com.eegeo.mapapi.polygons.PolygonOptions;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public class PolygonApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<Polygon> m_nativeHandleToPolygon = new SparseArray();

    public PolygonApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void register(Polygon polygon, Polygon.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToPolygon.put(polygon.getNativeHandle(allowHandleAccess), (Object)polygon);
    }

    @WorkerThread
    public void unregister(Polygon polygon, Polygon.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToPolygon.remove(polygon.getNativeHandle(allowHandleAccess));
    }

    @WorkerThread
    public int create(PolygonOptions polygonOptions, Polygon.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polygon");
        }
        if (polygonOptions.getPoints().size() < 2) {
            throw new InvalidParameterException("PolygonOptions points must contain at least two elements");
        }
        List<LatLng> exteriorPoints = polygonOptions.getPoints();
        List<List<LatLng>> holes = polygonOptions.getHoles();
        int[] ringVertexCounts = this.buildRingVertexCounts(exteriorPoints, holes);
        double[] allPointsDoubleArray = this.buildPointsArray(exteriorPoints, holes, ringVertexCounts);
        return this.nativeCreatePolygon(this.m_jniEegeoMapApiPtr, polygonOptions.getIndoorMapId(), polygonOptions.getIndoorFloorId(), polygonOptions.getElevation(), polygonOptions.getElevationMode().ordinal(), allPointsDoubleArray, ringVertexCounts, polygonOptions.getFillColor());
    }

    private double[] buildPointsArray(List<LatLng> exteriorPoints, List<List<LatLng>> holes, int[] ringVertexCounts) {
        int totalVertexCount = this.getTotalVertexCount(ringVertexCounts);
        ArrayList<LatLng> allPoints = new ArrayList<LatLng>(totalVertexCount);
        allPoints.addAll(exteriorPoints);
        for (List<LatLng> hole : holes) {
            allPoints.addAll(hole);
        }
        return this.pointsToDoubleArray(allPoints);
    }

    private int getTotalVertexCount(int[] ringVertexCounts) {
        int totalVertexCount = 0;
        for (int vertexCount : ringVertexCounts) {
            totalVertexCount += vertexCount;
        }
        return totalVertexCount;
    }

    private int[] buildRingVertexCounts(List<LatLng> exteriorPoints, List<List<LatLng>> holes) {
        int allRingsCount = holes.size() + 1;
        int[] ringVertexCounts = new int[allRingsCount];
        ringVertexCounts[0] = exteriorPoints.size();
        for (int holeIndex = 0; holeIndex < holes.size(); ++holeIndex) {
            ringVertexCounts[holeIndex + 1] = holes.get(holeIndex).size();
        }
        return ringVertexCounts;
    }

    private double[] pointsToDoubleArray(List<LatLng> points) {
        int pointCount = points.size();
        double[] coords = new double[pointCount * 2];
        for (int i = 0; i < pointCount; ++i) {
            coords[i * 2] = points.get((int)i).latitude;
            coords[i * 2 + 1] = points.get((int)i).longitude;
        }
        return coords;
    }

    @WorkerThread
    public void destroy(Polygon polygon, Polygon.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polygon");
        }
        this.nativeDestroyPolygon(this.m_jniEegeoMapApiPtr, polygon.getNativeHandle(allowHandleAccess));
    }

    @WorkerThread
    void setIndoorMap(int nativeHandle, Polygon.AllowHandleAccess allowHandleAccess, String indoorMapId, int indoorFloorId) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polygon");
        }
        this.nativeSetIndoorMap(this.m_jniEegeoMapApiPtr, nativeHandle, indoorMapId, indoorFloorId);
    }

    @WorkerThread
    void setElevation(int nativeHandle, Polygon.AllowHandleAccess allowHandleAccess, double elevation, ElevationMode elevationMode) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polygon");
        }
        this.nativeSetElevation(this.m_jniEegeoMapApiPtr, nativeHandle, elevation, elevationMode.ordinal());
    }

    @WorkerThread
    void setStyleAttributes(int nativeHandle, Polygon.AllowHandleAccess allowHandleAccess, int colorARGB) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polygon");
        }
        this.nativeSetStyleAttributes(this.m_jniEegeoMapApiPtr, nativeHandle, colorARGB);
    }

    @WorkerThread
    private native int nativeCreatePolygon(long var1, String var3, int var4, double var5, int var7, double[] var8, int[] var9, int var10);

    @WorkerThread
    private native void nativeDestroyPolygon(long var1, int var3);

    @WorkerThread
    private native void nativeSetIndoorMap(long var1, int var3, String var4, int var5);

    @WorkerThread
    private native void nativeSetElevation(long var1, int var3, double var4, int var6);

    @WorkerThread
    private native void nativeSetStyleAttributes(long var1, int var3, int var4);
}

