/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.eegeo.mapapi.EegeoMap;
import com.eegeo.mapapi.EegeoNativeMapView;
import com.eegeo.mapapi.MapViewTouchHandler;
import com.eegeo.mapapi.R;
import com.eegeo.mapapi.map.EegeoMapOptions;
import com.eegeo.mapapi.map.OnMapReadyCallback;
import com.eegeo.mapapi.util.Callbacks;

public class MapView
extends FrameLayout {
    private EegeoNativeMapView m_eegeoNativeMapView;
    private MapViewTouchHandler m_mapViewTouchHandler;
    private Callbacks.CallbackCollection1<EegeoMap> m_onReadyCallbacks = new Callbacks.CallbackCollection1();
    private boolean m_ready = false;
    private EegeoMap m_eegeoMap = null;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        if (this.isInEditMode()) {
            LayoutInflater.from((Context)context).inflate(R.layout.eegeo_mapview_preview, (ViewGroup)this);
        } else {
            EegeoMapOptions eegeoMapOptions = EegeoMapOptions.createFromAttributeSet(context, null);
            this.initialise(context, eegeoMapOptions);
        }
    }

    @UiThread
    public MapView(@NonNull Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (this.isInEditMode()) {
            LayoutInflater.from((Context)context).inflate(R.layout.eegeo_mapview_preview, (ViewGroup)this);
        } else {
            EegeoMapOptions eegeoMapOptions = EegeoMapOptions.createFromAttributeSet(context, attributeSet);
            this.initialise(context, eegeoMapOptions);
        }
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable EegeoMapOptions eegeoMapOptions) {
        super(context);
        if (eegeoMapOptions == null) {
            eegeoMapOptions = EegeoMapOptions.createFromAttributeSet(context, null);
        }
        this.initialise(context, eegeoMapOptions);
    }

    @UiThread
    private void initialise(@NonNull Context context, @NonNull EegeoMapOptions eegeoMapOptions) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.eegeo_mapview_internal, (ViewGroup)this);
        this.setClickable(true);
        this.setFocusable(true);
        this.m_eegeoNativeMapView = new EegeoNativeMapView(this, eegeoMapOptions);
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.surfaceView);
        surfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceHolderCallback());
        surfaceView.setVisibility(0);
        this.m_mapViewTouchHandler = new MapViewTouchHandler(this.m_eegeoNativeMapView);
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
    }

    @UiThread
    void notifyReady(EegeoMap eegeoMap) {
        this.m_ready = true;
        this.m_eegeoMap = eegeoMap;
        this.m_onReadyCallbacks.onCallback(this.m_eegeoMap);
    }

    @UiThread
    public void getMapAsync(OnMapReadyCallback callback) {
        if (this.m_ready) {
            callback.onMapReady(this.m_eegeoMap);
        } else {
            this.m_onReadyCallbacks.add((EegeoMap)((Object)new OnMapReadyCallbackImpl(callback)));
        }
    }

    @UiThread
    public void onResume() {
        this.m_eegeoNativeMapView.onResume();
    }

    @UiThread
    public void onPause() {
        this.m_eegeoNativeMapView.onPause();
    }

    @UiThread
    public void onDestroy() {
        this.m_eegeoNativeMapView.onDestroy();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.m_eegeoNativeMapView.draw();
    }

    public boolean onTouchEvent(MotionEvent e) {
        return this.m_mapViewTouchHandler.onTouchEvent(e) || super.onTouchEvent(e);
    }

    private class OnMapReadyCallbackImpl
    implements Callbacks.ICallback1<EegeoMap> {
        private final OnMapReadyCallback m_callback;

        public OnMapReadyCallbackImpl(OnMapReadyCallback callback) {
            this.m_callback = callback;
        }

        @Override
        public void onCallback(EegeoMap eegeoMap) {
            this.m_callback.onMapReady(eegeoMap);
        }
    }

    private class SurfaceHolderCallback
    implements SurfaceHolder.Callback {
        private SurfaceHolderCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            MapView.this.m_eegeoNativeMapView.surfaceCreated(holder);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            MapView.this.m_eegeoNativeMapView.surfaceDestroyed(holder);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            MapView.this.m_eegeoNativeMapView.surfaceChanged(holder, format, width, height);
        }
    }
}

