/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.util;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.util.Promise;
import com.eegeo.mapapi.util.Ready;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;

public class NativeApiObject {
    protected final INativeMessageRunner m_nativeRunner;
    protected final IUiMessageRunner m_uiRunner;
    private final Queue<Runnable> m_tasks = new ArrayDeque<Runnable>(0);
    private Integer m_nativeHandle = null;

    @UiThread
    public NativeApiObject(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, Callable<Integer> createHandleCallable) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        new NativeHandleFuture(createHandleCallable).then(new Ready<Integer>(){

            @Override
            @UiThread
            public void ready(Integer nativeHandle) {
                if (NativeApiObject.this.m_nativeHandle != null) {
                    throw new RuntimeException();
                }
                if (nativeHandle == null) {
                    throw new RuntimeException();
                }
                NativeApiObject.this.m_nativeHandle = nativeHandle;
                while (!NativeApiObject.this.m_tasks.isEmpty()) {
                    NativeApiObject.this.m_nativeRunner.runOnNativeThread((Runnable)NativeApiObject.this.m_tasks.poll());
                }
            }
        });
    }

    @WorkerThread
    protected boolean hasNativeHandle() {
        return this.m_nativeHandle != null;
    }

    @WorkerThread
    protected int getNativeHandle() {
        if (this.m_nativeHandle == null) {
            throw new RuntimeException("nativeHandle not yet available, ensure all calls to getNativeHandle are wrapped by submit()");
        }
        return this.m_nativeHandle;
    }

    @UiThread
    protected void destroyNativeHandle(Callable<Integer> destroyHandleCallable) {
        new NativeHandleFuture(destroyHandleCallable).then(new Ready<Integer>(){

            @Override
            public void ready(Integer result) {
                if (NativeApiObject.this.m_nativeHandle == null) {
                    throw new RuntimeException();
                }
                if (!NativeApiObject.this.m_tasks.isEmpty()) {
                    throw new RuntimeException();
                }
                NativeApiObject.this.m_nativeHandle = null;
            }
        });
    }

    @UiThread
    protected void submit(Runnable task) {
        if (this.m_nativeHandle == null) {
            this.m_tasks.add(task);
        } else {
            this.m_nativeRunner.runOnNativeThread(task);
        }
    }

    private class NativeHandleFuture
    extends Promise<Integer> {
        @UiThread
        public NativeHandleFuture(final Callable<Integer> createHandleCallable) {
            NativeApiObject.this.m_nativeRunner.runOnNativeThread(new Runnable(){

                @Override
                @WorkerThread
                public void run() {
                    try {
                        final Integer nativeHandle = (Integer)createHandleCallable.call();
                        if (nativeHandle == null) {
                            throw new RuntimeException("createHandleCallable failed to return non-null handle");
                        }
                        NativeApiObject.this.m_uiRunner.runOnUiThread(new Runnable(){

                            @Override
                            @UiThread
                            public void run() {
                                NativeHandleFuture.this.ready(nativeHandle);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException();
                    }
                }
            });
        }
    }
}

