/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.geometry;

import android.support.annotation.NonNull;
import com.eegeo.mapapi.geometry.LatLng;

public class LatLngBounds {
    public final LatLng southwest;
    public final LatLng northeast;

    public LatLngBounds(@NonNull LatLng southwest, @NonNull LatLng northeast) throws IllegalArgumentException {
        if (northeast.latitude < southwest.latitude) {
            throw new IllegalArgumentException();
        }
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds including(@NonNull LatLng point) {
        return new LatLngBounds(new LatLng(Math.min(this.southwest.latitude, point.latitude), Math.min(this.southwest.longitude, point.longitude)), new LatLng(Math.max(this.northeast.latitude, point.latitude), Math.max(this.northeast.longitude, point.longitude)));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LatLngBounds llb = (LatLngBounds)other;
        return llb.southwest.equals(this.southwest) && llb.northeast.equals(this.northeast);
    }

    public static final class Builder {
        private LatLngBounds m_bounds;

        public Builder include(@NonNull LatLng point) {
            this.m_bounds = this.m_bounds == null ? new LatLngBounds(point, point) : this.m_bounds.including(point);
            return this;
        }

        public LatLngBounds build() {
            if (this.m_bounds == null) {
                throw new IllegalStateException("unable to build LatLngBounds from empty list of points");
            }
            return this.m_bounds;
        }
    }
}

