/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.camera;

import android.graphics.Point;
import android.support.annotation.UiThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.LatLngAlt;
import com.eegeo.mapapi.util.Promise;

public class Projection {
    private final long m_eegeoMapApiPtr;
    private final INativeMessageRunner m_nativeRunner;
    private final IUiMessageRunner m_uiRunner;

    public Projection(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long eegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_eegeoMapApiPtr = eegeoMapApiPtr;
    }

    @UiThread
    public Promise<LatLngAlt> fromScreenLocation(final Point point) {
        final Promise<LatLngAlt> p = new Promise<LatLngAlt>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final double[] latLongAlt = Projection.this.nativeScreenToTerrainPoint(Projection.this.m_eegeoMapApiPtr, point.x, point.y);
                Projection.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(new LatLngAlt(latLongAlt[0], latLongAlt[1], latLongAlt[2]));
                    }
                });
            }
        });
        return p;
    }

    @UiThread
    public Promise<Point> toScreenLocation(final LatLngAlt location) {
        final Promise<Point> p = new Promise<Point>();
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                final double[] screen = Projection.this.nativeWorldToScreen(Projection.this.m_eegeoMapApiPtr, location.latitude, location.longitude, location.altitude);
                Projection.this.m_uiRunner.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        p.ready(new Point((int)screen[0], (int)screen[1]));
                    }
                });
            }
        });
        return p;
    }

    private native double[] nativeWorldToScreen(long var1, double var3, double var5, double var7);

    private native double[] nativeScreenToTerrainPoint(long var1, double var3, double var5);
}

