/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.markers;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.markers.Marker;
import com.eegeo.mapapi.markers.MarkerOptions;
import com.eegeo.mapapi.markers.OnMarkerClickListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class MarkerApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private ArrayList<OnMarkerClickListener> m_onMarkerClickListeners = new ArrayList();
    private SparseArray<Marker> m_nativeHandleToMarker = new SparseArray();

    public MarkerApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    public IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void registerMarker(Marker marker, Marker.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToMarker.put(marker.getNativeHandle(allowHandleAccess), (Object)marker);
    }

    @WorkerThread
    public void unregisterMarker(Marker marker, Marker.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToMarker.remove(marker.getNativeHandle(allowHandleAccess));
    }

    @UiThread
    public void addMarkerClickListener(OnMarkerClickListener listener) {
        this.m_onMarkerClickListeners.add(listener);
    }

    @UiThread
    public void removeMarkerClickListener(OnMarkerClickListener listener) {
        this.m_onMarkerClickListeners.remove(listener);
    }

    @WorkerThread
    public int createMarker(MarkerOptions markerOptions, Marker.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Marker");
        }
        LatLng location = markerOptions.getPosition();
        if (location == null) {
            throw new InvalidParameterException("MarkerOptions position must be set");
        }
        return this.nativeCreateMarker(this.m_jniEegeoMapApiPtr, location.latitude, location.longitude, markerOptions.getElevation(), markerOptions.getElevationMode().ordinal(), markerOptions.getIndoorMapId(), markerOptions.getIndoorFloorId(), markerOptions.getTitle(), markerOptions.getIconKey(), markerOptions.getUserData(), markerOptions.getDrawOrder());
    }

    @WorkerThread
    public void destroy(Marker marker, Marker.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Marker");
        }
        this.nativeDestroyMarker(this.m_jniEegeoMapApiPtr, marker.getNativeHandle(allowHandleAccess));
    }

    @WorkerThread
    public void updateLocation(int markerNativeHandle, Marker.AllowHandleAccess allowHandleAccess, LatLng position, double elevation, MarkerOptions.MarkerElevationMode elevationMode) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Marker");
        }
        this.nativeUpdateLocation(this.m_jniEegeoMapApiPtr, markerNativeHandle, position.latitude, position.longitude, elevation, elevationMode.ordinal());
    }

    @WorkerThread
    public void updateLabel(int markerNativeHandle, Marker.AllowHandleAccess allowHandleAccess, String title, String iconKey, int drawOrder) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Marker");
        }
        this.nativeUpdateLabel(this.m_jniEegeoMapApiPtr, markerNativeHandle, title, iconKey, drawOrder);
    }

    @WorkerThread
    public void notifyMarkerClicked(int markerId) {
        if (this.m_nativeHandleToMarker.get(markerId) != null) {
            final Marker marker = (Marker)this.m_nativeHandleToMarker.get(markerId);
            this.m_uiRunner.runOnUiThread(new Runnable(){

                @Override
                @UiThread
                public void run() {
                    for (OnMarkerClickListener listener : MarkerApi.this.m_onMarkerClickListeners) {
                        listener.onMarkerClick(marker);
                    }
                }
            });
        }
    }

    @WorkerThread
    private native int nativeCreateMarker(long var1, double var3, double var5, double var7, int var9, String var10, int var11, String var12, String var13, String var14, int var15);

    @WorkerThread
    private native void nativeDestroyMarker(long var1, int var3);

    @WorkerThread
    private native void nativeUpdateLocation(long var1, int var3, double var4, double var6, double var8, int var10);

    @WorkerThread
    private native void nativeUpdateLabel(long var1, int var3, String var4, String var5, int var6);
}

