/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.eegeo.mapapi.EegeoApi;
import com.eegeo.mapapi.EegeoMap;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.MapView;
import com.eegeo.mapapi.UiThreadRunner;
import com.eegeo.mapapi.map.EegeoMapOptions;
import java.util.concurrent.Callable;

public class EegeoNativeMapView
implements INativeMessageRunner {
    private final NativeThread m_nativeThread;
    private final MapView m_mapView;
    private final UiThreadRunner m_uiRunner;
    private SurfaceHolder m_surfaceHolder;
    private long m_jniApiRunnerPtr;
    private EegeoMap m_eeGeoMap = null;
    private Point m_mouseDownPoint = new Point(0, 0);
    private Callable<EegeoMap> m_createEegeoMapNativeCallable;

    @UiThread
    public EegeoNativeMapView(MapView mapView, final @NonNull EegeoMapOptions eegeoMapOptions) throws RuntimeException {
        final Context context = mapView.getContext();
        this.m_uiRunner = new UiThreadRunner(context);
        this.m_mapView = mapView;
        this.m_nativeThread = new NativeThread(eegeoMapOptions.getTargetFrameRate());
        this.m_nativeThread.start();
        this.m_createEegeoMapNativeCallable = new Callable<EegeoMap>(){

            @Override
            @WorkerThread
            public EegeoMap call() throws Exception {
                EegeoMap eeGeoMap = new EegeoMap(EegeoNativeMapView.this, EegeoNativeMapView.this.m_uiRunner, new CreateEegeoMapApiImpl());
                eeGeoMap.initialise(eegeoMapOptions);
                return eeGeoMap;
            }
        };
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                context.getResources();
                DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
                try {
                    PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                    EegeoNativeMapView.this.m_jniApiRunnerPtr = EegeoNativeMapView.this.nativeCreateApiRunner(EegeoNativeMapView.this, context, context.getAssets(), dm.ydpi, dm.densityDpi, packageInfo.versionName, packageInfo.versionCode);
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Failed to get PackageInfo");
                }
                if (EegeoNativeMapView.this.m_jniApiRunnerPtr == 0L) {
                    throw new RuntimeException("Failed to start native code.");
                }
            }
        });
    }

    @Override
    @UiThread
    public void runOnNativeThread(Runnable runnable) {
        this.m_nativeThread.postTo(runnable);
    }

    @UiThread
    public void onResume() {
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                if (EegeoNativeMapView.this.m_surfaceHolder != null && EegeoNativeMapView.this.m_surfaceHolder.getSurface() != null) {
                    EegeoNativeMapView.this.nativeSetSurface(EegeoNativeMapView.this.m_jniApiRunnerPtr, EegeoNativeMapView.this.m_surfaceHolder.getSurface());
                    EegeoNativeMapView.this.nativeResumeApiRunner(EegeoNativeMapView.this.m_jniApiRunnerPtr);
                }
                EegeoNativeMapView.this.m_nativeThread.startUpdating();
            }
        });
    }

    @UiThread
    public void onPause() {
        Log.d((String)"eegeo-android-sdk", (String)"onPause");
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EegeoNativeMapView.this.m_nativeThread.stopUpdating();
                EegeoNativeMapView.this.nativePauseApiRunner(EegeoNativeMapView.this.m_jniApiRunnerPtr);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void onDestroy() {
        Log.d((String)"eegeo-android-sdk", (String)"onDestroy");
        this.runOnNativeThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @WorkerThread
            public void run() {
                Log.d((String)"eegeo-android-sdk", (String)"Native Thread: onDestroy");
                EegeoNativeMapView.this.m_nativeThread.stopUpdating();
                EegeoNativeMapView.this.nativeDestroyApiRunner(EegeoNativeMapView.this.m_jniApiRunnerPtr);
                EegeoNativeMapView.this.m_jniApiRunnerPtr = 0L;
                NativeThread nativeThread = EegeoNativeMapView.this.m_nativeThread;
                synchronized (nativeThread) {
                    EegeoNativeMapView.this.m_nativeThread.notifyAll();
                }
            }
        });
        Log.d((String)"eegeo-android-sdk", (String)"begin wait nativeDestroyApiRunner");
        NativeThread nativeThread = this.m_nativeThread;
        synchronized (nativeThread) {
            try {
                this.m_nativeThread.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Log.d((String)"eegeo-android-sdk", (String)"end wait nativeDestroyApiRunner");
        this.m_nativeThread.quit();
    }

    @UiThread
    public void onPointerDown(final int primaryActionIndex, final int primaryActionIdentifier, final int pointerCount, final float[] x, final float[] y, final int[] pointerIdentity, final int[] pointerIndex) {
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EegeoNativeMapView.this.nativeProcessPointerDown(EegeoNativeMapView.this.m_jniApiRunnerPtr, primaryActionIndex, primaryActionIdentifier, pointerCount, x, y, pointerIdentity, pointerIndex);
            }
        });
        if (x.length > 0) {
            this.m_mouseDownPoint.x = (int)x[0];
            this.m_mouseDownPoint.y = (int)y[0];
        }
    }

    @UiThread
    public void onPointerUp(final int primaryActionIndex, final int primaryActionIdentifier, final int pointerCount, final float[] x, final float[] y, final int[] pointerIdentity, final int[] pointerIndex) {
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EegeoNativeMapView.this.nativeProcessPointerUp(EegeoNativeMapView.this.m_jniApiRunnerPtr, primaryActionIndex, primaryActionIdentifier, pointerCount, x, y, pointerIdentity, pointerIndex);
            }
        });
        if (this.m_eeGeoMap == null) {
            Log.d((String)"eegeo-android-sdk", (String)"skipping input event -- map not ready");
            return;
        }
        if (x.length > 0) {
            Point mouseUpPoint = new Point((int)x[0], (int)y[0]);
            double distSquared = Math.pow(mouseUpPoint.x - this.m_mouseDownPoint.x, 2.0) + Math.pow(mouseUpPoint.y - this.m_mouseDownPoint.y, 2.0);
            if (distSquared < 25.0) {
                this.m_eeGeoMap.onTapped(mouseUpPoint);
            }
        }
    }

    @UiThread
    public void onPointerMove(final int primaryActionIndex, final int primaryActionIdentifier, final int pointerCount, final float[] x, final float[] y, final int[] pointerIdentity, final int[] pointerIndex) {
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EegeoNativeMapView.this.nativeProcessPointerMove(EegeoNativeMapView.this.m_jniApiRunnerPtr, primaryActionIndex, primaryActionIdentifier, pointerCount, x, y, pointerIdentity, pointerIndex);
            }
        });
    }

    public void draw() {
    }

    @WorkerThread
    private void notifySurfaceCreated() {
        if (this.m_eeGeoMap == null) {
            try {
                this.m_eeGeoMap = this.m_createEegeoMapNativeCallable.call();
                this.m_createEegeoMapNativeCallable = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to create native eeGeo Map object");
            }
            this.m_uiRunner.runOnUiThread(new Runnable(){

                @Override
                @UiThread
                public void run() {
                    EegeoNativeMapView.this.m_mapView.notifyReady(EegeoNativeMapView.this.m_eeGeoMap);
                }
            });
        }
        this.nativeResumeApiRunner(this.m_jniApiRunnerPtr);
        this.m_nativeThread.startUpdating();
    }

    @WorkerThread
    private void notifySurfaceDestroyed() {
        this.m_nativeThread.stopUpdating();
        this.m_surfaceHolder = null;
    }

    @UiThread
    public void surfaceCreated(final SurfaceHolder holder) {
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EegeoNativeMapView.this.m_surfaceHolder = holder;
                Surface surface = EegeoNativeMapView.this.m_surfaceHolder.getSurface();
                if (surface.isValid()) {
                    EegeoNativeMapView.this.nativeSetSurface(EegeoNativeMapView.this.m_jniApiRunnerPtr, surface);
                    EegeoNativeMapView.this.notifySurfaceCreated();
                }
            }
        });
    }

    @UiThread
    public void surfaceDestroyed(final SurfaceHolder holder) {
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                if (EegeoNativeMapView.this.m_surfaceHolder == holder) {
                    EegeoNativeMapView.this.notifySurfaceDestroyed();
                }
            }
        });
    }

    @UiThread
    public void surfaceChanged(final SurfaceHolder holder, int format, int width, int height) {
        this.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Surface surface;
                EegeoNativeMapView.this.m_surfaceHolder = holder;
                if (EegeoNativeMapView.this.m_surfaceHolder != null && (surface = EegeoNativeMapView.this.m_surfaceHolder.getSurface()).isValid()) {
                    EegeoNativeMapView.this.nativeSetSurface(EegeoNativeMapView.this.m_jniApiRunnerPtr, surface);
                }
            }
        });
    }

    @WorkerThread
    private native long nativeCreateApiRunner(EegeoNativeMapView var1, Context var2, AssetManager var3, float var4, int var5, String var6, int var7);

    @WorkerThread
    private native void nativeDestroyApiRunner(long var1);

    @WorkerThread
    private native void nativePauseApiRunner(long var1);

    @WorkerThread
    private native void nativeResumeApiRunner(long var1);

    @WorkerThread
    private native void nativeSetSurface(long var1, Surface var3);

    @WorkerThread
    private native long nativeCreateEegeoMapApi(long var1, String var3, EegeoMap var4);

    @WorkerThread
    private native void nativeUpdateApiRunner(long var1, float var3);

    @WorkerThread
    private native void nativeProcessPointerDown(long var1, int var3, int var4, int var5, float[] var6, float[] var7, int[] var8, int[] var9);

    @WorkerThread
    private native void nativeProcessPointerUp(long var1, int var3, int var4, int var5, float[] var6, float[] var7, int[] var8, int[] var9);

    @WorkerThread
    private native void nativeProcessPointerMove(long var1, int var3, int var4, int var5, float[] var6, float[] var7, int[] var8, int[] var9);

    static {
        System.loadLibrary("eegeo-jni");
    }

    private class NativeThread
    extends Thread {
        private final float m_targetFramesPerSecond;
        private Handler m_nativeThreadHandler;
        private NativeUpdateApiRunner m_nativeUpdateApiRunner;
        private boolean m_updatingNative = false;
        private boolean m_threadExiting = false;

        @UiThread
        private NativeThread(float m_targetFramesPerSecond) {
            this.m_targetFramesPerSecond = m_targetFramesPerSecond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @UiThread
        public void start() {
            super.start();
            NativeThread nativeThread = this;
            synchronized (nativeThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException("failed to start NativeThread");
                }
            }
            if (this.m_nativeThreadHandler == null) {
                throw new RuntimeException("failed to create nativeThreadHandler");
            }
        }

        @UiThread
        public void postTo(Runnable runnable) {
            if (!this.m_threadExiting) {
                this.m_nativeThreadHandler.post(runnable);
            } else {
                Log.d((String)"eegeo-android-sdk", (String)"thread exiting, ignoring runnable");
            }
        }

        @WorkerThread
        public void startUpdating() {
            if (!this.m_updatingNative) {
                this.m_updatingNative = true;
                this.m_nativeThreadHandler.post((Runnable)this.m_nativeUpdateApiRunner);
            }
        }

        @WorkerThread
        public void stopUpdating() {
            if (this.m_updatingNative) {
                this.m_updatingNative = false;
                this.m_nativeThreadHandler.removeCallbacks((Runnable)this.m_nativeUpdateApiRunner);
            }
        }

        @UiThread
        public void quit() {
            this.m_threadExiting = true;
            this.m_nativeThreadHandler.removeCallbacksAndMessages(null);
            this.m_nativeThreadHandler.post(new Runnable(){

                @Override
                @WorkerThread
                public void run() {
                    Looper.myLooper().quit();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            this.m_nativeUpdateApiRunner = new NativeUpdateApiRunner();
            this.m_nativeThreadHandler = new Handler();
            NativeThread nativeThread = this;
            synchronized (nativeThread) {
                this.notifyAll();
            }
            Looper.loop();
        }

        class NativeUpdateApiRunner
        implements Runnable {
            private final float m_frameThrottleDelaySeconds;
            private long m_startOfLastFrameNano = System.nanoTime();

            @WorkerThread
            NativeUpdateApiRunner() {
                this.m_frameThrottleDelaySeconds = 1.0f / NativeThread.this.m_targetFramesPerSecond;
            }

            @Override
            @WorkerThread
            public void run() {
                long timeNowNano = System.nanoTime();
                long nanoDelta = timeNowNano - this.m_startOfLastFrameNano;
                float deltaSeconds = (float)((double)nanoDelta / 1.0E9);
                if (deltaSeconds > this.m_frameThrottleDelaySeconds) {
                    EegeoNativeMapView.this.nativeUpdateApiRunner(EegeoNativeMapView.this.m_jniApiRunnerPtr, deltaSeconds);
                    this.m_startOfLastFrameNano = timeNowNano;
                    NativeThread.this.m_nativeThreadHandler.post((Runnable)this);
                } else {
                    long waitMS = Math.max(0L, (long)(1000.0f * (this.m_frameThrottleDelaySeconds - deltaSeconds)));
                    NativeThread.this.m_nativeThreadHandler.postDelayed((Runnable)this, waitMS);
                }
            }
        }
    }

    private class CreateEegeoMapApiImpl
    implements ICreateEegeoMapApi {
        private CreateEegeoMapApiImpl() {
        }

        @Override
        @WorkerThread
        public long create(EegeoMap eegeoMap) {
            String apiKey = EegeoApi.getInstance().getApiKey();
            long jniEegeoMapApiPtr = EegeoNativeMapView.this.nativeCreateEegeoMapApi(EegeoNativeMapView.this.m_jniApiRunnerPtr, apiKey, eegeoMap);
            return jniEegeoMapApiPtr;
        }
    }

    static interface ICreateEegeoMapApi {
        @WorkerThread
        public long create(EegeoMap var1);
    }
}

