/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.indooroutlines;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.indooroutlines.IndoorMapFloorOutlineInformation;
import com.eegeo.mapapi.indooroutlines.IndoorMapFloorOutlinePolygon;
import java.security.InvalidParameterException;

public class IndoorMapFloorOutlineInformationApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<IndoorMapFloorOutlineInformation> m_nativeHandleToIndoorMapFloorOutlineInformation = new SparseArray();

    public IndoorMapFloorOutlineInformationApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    public IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void register(IndoorMapFloorOutlineInformation indoorMapFloorOutlineInformation, IndoorMapFloorOutlineInformation.AllowHandleAccess allowHandleAccess) {
        int nativeHandle = indoorMapFloorOutlineInformation.getNativeHandle(allowHandleAccess);
        this.m_nativeHandleToIndoorMapFloorOutlineInformation.put(nativeHandle, (Object)indoorMapFloorOutlineInformation);
        this.fetchIndoorMapFloorOutlineInformation(nativeHandle);
    }

    @WorkerThread
    public int create(String indoorMapId, int indoorMapFloorId, IndoorMapFloorOutlineInformation.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by IndoorMapEntityInformation");
        }
        return this.nativeCreateIndoorMapFloorOutlineInformation(this.m_jniEegeoMapApiPtr, indoorMapId, indoorMapFloorId);
    }

    @WorkerThread
    public void destroy(IndoorMapFloorOutlineInformation indoorMapFloorOutlineInformation, IndoorMapFloorOutlineInformation.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by IndoorMapEntityInformation");
        }
        int nativeHandle = indoorMapFloorOutlineInformation.getNativeHandle(allowHandleAccess);
        if (this.m_nativeHandleToIndoorMapFloorOutlineInformation.get(nativeHandle) != null) {
            this.nativeDestroyIndoorMapFloorOutlineInformation(this.m_jniEegeoMapApiPtr, nativeHandle);
            this.m_nativeHandleToIndoorMapFloorOutlineInformation.remove(nativeHandle);
        }
    }

    @WorkerThread
    public void notifyIndoorMapFloorOutlineInformationLoaded(int nativeHandle) {
        if (this.m_nativeHandleToIndoorMapFloorOutlineInformation.get(nativeHandle) != null) {
            this.fetchIndoorMapFloorOutlineInformation(nativeHandle);
        }
    }

    @WorkerThread
    private void fetchIndoorMapFloorOutlineInformation(int nativeHandle) {
        final IndoorMapFloorOutlineInformation indoorMapFloorOutlineInformation = (IndoorMapFloorOutlineInformation)this.m_nativeHandleToIndoorMapFloorOutlineInformation.get(nativeHandle);
        if (indoorMapFloorOutlineInformation == null) {
            throw new NullPointerException("IndoorMapFloorOutlineInformation object not found for nativeHandle");
        }
        if (!this.nativeGetIndoorMapFloorOutlineInformationLoaded(this.m_jniEegeoMapApiPtr, nativeHandle)) {
            return;
        }
        final IndoorMapFloorOutlinePolygon[] indoorMapFloorOutlinePolygons = this.nativeGetIndoorMapFloorOutlinePolygon(this.m_jniEegeoMapApiPtr, nativeHandle);
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                indoorMapFloorOutlineInformation.updateFromNative(indoorMapFloorOutlinePolygons);
            }
        });
    }

    @WorkerThread
    private native int nativeCreateIndoorMapFloorOutlineInformation(long var1, String var3, int var4);

    @WorkerThread
    private native void nativeDestroyIndoorMapFloorOutlineInformation(long var1, int var3);

    @WorkerThread
    private native boolean nativeGetIndoorMapFloorOutlineInformationLoaded(long var1, int var3);

    @WorkerThread
    private native IndoorMapFloorOutlinePolygon[] nativeGetIndoorMapFloorOutlinePolygon(long var1, int var3);
}

