/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.props;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.props.PropOptions;
import com.eegeo.mapapi.props.PropsApi;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class Prop
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final PropsApi m_propsApi;
    private String m_indoorMapId;
    private int m_indoorFloorId;
    private double m_elevation;
    private ElevationMode m_elevationMode;
    private LatLng m_position;
    private double m_headingDegrees;
    private String m_geometryId;

    @UiThread
    public Prop(final @NonNull PropsApi propsApi, final @NonNull PropOptions propOptions) {
        super(propsApi.getNativeRunner(), propsApi.getUiRunner(), new Callable<Integer>(){

            @Override
            public Integer call() {
                return propsApi.create(propOptions, m_allowHandleAccess);
            }
        });
        this.m_propsApi = propsApi;
        this.m_indoorMapId = propOptions.getIndoorMapId();
        this.m_indoorFloorId = propOptions.getIndoorFloorId();
        this.m_elevation = propOptions.getElevation();
        this.m_elevationMode = propOptions.getElevationMode();
        this.m_position = propOptions.getPosition();
        this.m_headingDegrees = propOptions.getHeadingDegrees();
        this.m_geometryId = propOptions.getGeometryId();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                propsApi.register(Prop.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateNativeElevation();
    }

    @UiThread
    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    @UiThread
    public void setElevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        this.updateNativeElevationMode();
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    @UiThread
    public double getHeadingDegrees() {
        return this.m_headingDegrees;
    }

    @UiThread
    public void setHeadingDegrees(double headingDegrees) {
        this.m_headingDegrees = headingDegrees;
        this.updateNativeHeadingDegrees();
    }

    @UiThread
    public LatLng getPosition() {
        return this.m_position;
    }

    @UiThread
    public void setPosition(LatLng position) {
        this.m_position = position;
        this.updateNativePosition();
    }

    @UiThread
    public String getGeometryId() {
        return this.m_geometryId;
    }

    @UiThread
    public void setGeometryId(String geometryId) {
        this.m_geometryId = geometryId;
        this.updateNativeGeometryId();
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Prop.this.m_propsApi.destroy(Prop.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    private void updateNativePosition() {
        final LatLng position = this.m_position;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Prop.this.m_propsApi.setPosition(Prop.this.getNativeHandle(), m_allowHandleAccess, position);
            }
        });
    }

    @UiThread
    private void updateNativeGeometryId() {
        final String geometryId = this.m_geometryId;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Prop.this.m_propsApi.setGeometryId(Prop.this.getNativeHandle(), m_allowHandleAccess, geometryId);
            }
        });
    }

    @UiThread
    private void updateNativeElevation() {
        final double elevation = this.m_elevation;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Prop.this.m_propsApi.setElevation(Prop.this.getNativeHandle(), m_allowHandleAccess, elevation);
            }
        });
    }

    @UiThread
    private void updateNativeElevationMode() {
        final ElevationMode elevationMode = this.m_elevationMode;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Prop.this.m_propsApi.setElevationMode(Prop.this.getNativeHandle(), m_allowHandleAccess, elevationMode);
            }
        });
    }

    @UiThread
    private void updateNativeHeadingDegrees() {
        final double headingDegrees = this.m_headingDegrees;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Prop.this.m_propsApi.setHeadingDegrees(Prop.this.getNativeHandle(), m_allowHandleAccess, headingDegrees);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by PolygonApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

