/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.camera;

import android.support.annotation.NonNull;
import com.eegeo.mapapi.camera.CameraPosition;
import com.eegeo.mapapi.camera.CameraUpdate;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.LatLngBounds;

public final class CameraUpdateFactory {
    private CameraUpdateFactory() {
    }

    public static CameraUpdate newCameraPosition(@NonNull CameraPosition cameraPosition) {
        return new IdentityCameraPositionUpdate(cameraPosition);
    }

    public static CameraUpdate newLatLng(@NonNull LatLng latLng) {
        return new IdentityCameraPositionUpdate(new CameraPosition.Builder().target(latLng).build());
    }

    public static CameraUpdate newLatLngBounds(@NonNull LatLngBounds bounds, int padding) {
        return new LatLongBoundsCameraPositionUpdate(bounds);
    }

    public static final class LatLongBoundsCameraPositionUpdate
    implements CameraUpdate {
        private final LatLngBounds m_latLngBounds;

        public LatLongBoundsCameraPositionUpdate(@NonNull LatLngBounds latLngBounds) {
            this.m_latLngBounds = latLngBounds;
        }

        public final LatLngBounds getLatLngBounds() {
            return this.m_latLngBounds;
        }

        @Override
        public CameraUpdate.CameraUpdateType getUpdateType() {
            return CameraUpdate.CameraUpdateType.LatLngBounds;
        }
    }

    public static final class IdentityCameraPositionUpdate
    implements CameraUpdate {
        private final CameraPosition m_cameraPosition;

        public IdentityCameraPositionUpdate(@NonNull CameraPosition position) {
            this.m_cameraPosition = position;
        }

        public final CameraPosition getCameraPosition() {
            return this.m_cameraPosition;
        }

        @Override
        public CameraUpdate.CameraUpdateType getUpdateType() {
            return CameraUpdate.CameraUpdateType.CameraPosition;
        }
    }
}

