/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.precaching;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.precaching.OnPrecacheOperationCompletedListener;
import com.eegeo.mapapi.precaching.PrecacheApiJniCalls;
import com.eegeo.mapapi.precaching.PrecacheOperation;
import com.eegeo.mapapi.precaching.PrecacheOperationResult;

public class PrecacheApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private final double m_maximumPrecacheRadius;
    private SparseArray<PrecacheOperation> m_operations = new SparseArray();

    @WorkerThread
    public PrecacheApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
        this.m_maximumPrecacheRadius = PrecacheApiJniCalls.getMaximumPrecacheRadius();
    }

    @UiThread
    public PrecacheOperation precache(LatLng center, double radius, OnPrecacheOperationCompletedListener callback) {
        return new PrecacheOperation(this, center, radius, callback);
    }

    @UiThread
    public double getMaximumPrecacheRadius() {
        return this.m_maximumPrecacheRadius;
    }

    @WorkerThread
    int beginPrecacheOperation(LatLng center, double radius) {
        return PrecacheApiJniCalls.beginPrecacheOperation(this.m_jniEegeoMapApiPtr, center.latitude, center.longitude, radius);
    }

    @WorkerThread
    void register(PrecacheOperation operation, int operationId) {
        this.m_operations.put(operationId, (Object)operation);
    }

    @WorkerThread
    void cancelPrecacheOperation(int operationId) {
        PrecacheApiJniCalls.cancelPrecacheOperation(this.m_jniEegeoMapApiPtr, operationId);
    }

    @WorkerThread
    public void notifyPrecacheOperationComplete(int precacheOperationId, final PrecacheOperationResult result) {
        final PrecacheOperation operation = (PrecacheOperation)this.m_operations.get(precacheOperationId);
        if (operation != null) {
            this.m_operations.remove(precacheOperationId);
            this.m_uiRunner.runOnUiThread(new Runnable(){

                @Override
                @UiThread
                public void run() {
                    operation.returnResult(result);
                }
            });
        }
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }
}

