/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.props;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.props.Prop;
import com.eegeo.mapapi.props.PropOptions;
import java.security.InvalidParameterException;

public class PropsApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<Prop> m_nativeHandleToProp = new SparseArray();

    @WorkerThread
    public void register(Prop prop, Prop.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToProp.put(prop.getNativeHandle(allowHandleAccess), (Object)prop);
    }

    public PropsApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @WorkerThread
    public int create(PropOptions propOptions, Prop.AllowHandleAccess allowHandleAccess) throws InvalidParameterException, NullPointerException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Prop");
        }
        if (propOptions.getIndoorMapId().isEmpty()) {
            throw new InvalidParameterException("PropOptions must specify an indoor map Id");
        }
        if (propOptions.getGeometryId().isEmpty()) {
            throw new InvalidParameterException("PropOptions must specify a geometry Id");
        }
        return this.nativeCreateProp(this.m_jniEegeoMapApiPtr, propOptions.getIndoorMapId(), propOptions.getIndoorFloorId(), propOptions.getName(), propOptions.getPosition().latitude, propOptions.getPosition().longitude, propOptions.getElevation(), propOptions.getElevationMode().ordinal(), propOptions.getHeadingDegrees(), propOptions.getGeometryId());
    }

    @WorkerThread
    public void destroy(Prop prop, Prop.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Prop");
        }
        int nativeHandle = prop.getNativeHandle(allowHandleAccess);
        if (this.m_nativeHandleToProp.get(nativeHandle) != null) {
            this.nativeDestroyProp(this.m_jniEegeoMapApiPtr, nativeHandle);
            this.m_nativeHandleToProp.remove(nativeHandle);
        }
    }

    @WorkerThread
    public void setPosition(int nativeHandle, Prop.AllowHandleAccess allowHandleAccess, LatLng position) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Prop");
        }
        this.nativeSetLocation(this.m_jniEegeoMapApiPtr, nativeHandle, position.latitude, position.longitude);
    }

    @WorkerThread
    public void setHeadingDegrees(int nativeHandle, Prop.AllowHandleAccess allowHandleAccess, double headingDegrees) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Prop");
        }
        this.nativeSetHeadingDegrees(this.m_jniEegeoMapApiPtr, nativeHandle, headingDegrees);
    }

    @WorkerThread
    public void setGeometryId(int nativeHandle, Prop.AllowHandleAccess allowHandleAccess, String geometryId) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Prop");
        }
        this.nativeSetGeometryId(this.m_jniEegeoMapApiPtr, nativeHandle, geometryId);
    }

    @WorkerThread
    public void setElevation(int nativeHandle, Prop.AllowHandleAccess allowHandleAccess, double elevation) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Prop");
        }
        this.nativeSetElevation(this.m_jniEegeoMapApiPtr, nativeHandle, elevation);
    }

    @WorkerThread
    public void setElevationMode(int nativeHandle, Prop.AllowHandleAccess allowHandleAccess, ElevationMode elevationMode) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Prop");
        }
        this.nativeSetElevationMode(this.m_jniEegeoMapApiPtr, nativeHandle, elevationMode.ordinal());
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    private native int nativeCreateProp(long var1, String var3, int var4, String var5, double var6, double var8, double var10, int var12, double var13, String var15);

    @WorkerThread
    private native void nativeDestroyProp(long var1, int var3);

    @WorkerThread
    private native void nativeSetHeadingDegrees(long var1, int var3, double var4);

    @WorkerThread
    private native void nativeSetGeometryId(long var1, int var3, String var4);

    @WorkerThread
    private native void nativeSetElevation(long var1, int var3, double var4);

    @WorkerThread
    private native void nativeSetLocation(long var1, int var3, double var4, double var6);

    @WorkerThread
    private native void nativeSetElevationMode(long var1, int var3, int var4);
}

