/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.indoorentities;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.indoorentities.IndoorEntityPickedMessage;
import com.eegeo.mapapi.indoorentities.OnIndoorEntityPickedListener;
import java.util.ArrayList;
import java.util.List;

public class IndoorEntityApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private List<OnIndoorEntityPickedListener> m_onIndoorEntityPickedListeners = new ArrayList<OnIndoorEntityPickedListener>();

    public IndoorEntityApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public void setIndoorEntityHighlights(final @NonNull String indoorMapId, final @NonNull List<String> indoorEntityIds, final @NonNull int highlightColor) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                IndoorEntityApi.this.nativeSetIndoorEntityHighlights(IndoorEntityApi.this.m_jniEegeoMapApiPtr, indoorMapId, indoorEntityIds, highlightColor);
            }
        });
    }

    @UiThread
    public void clearIndoorEntityHighlights(final String indoorMapId, final List<String> indoorEntityIds) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                IndoorEntityApi.this.nativeClearIndoorEntityHighlights(IndoorEntityApi.this.m_jniEegeoMapApiPtr, indoorMapId, indoorEntityIds);
            }
        });
    }

    @UiThread
    public void clearAllIndoorEntityHighlights() {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                IndoorEntityApi.this.nativeClearAllIndoorEntityHighlights(IndoorEntityApi.this.m_jniEegeoMapApiPtr);
            }
        });
    }

    @UiThread
    public void addOnIndoorEntityPickedListener(OnIndoorEntityPickedListener listener) {
        this.m_onIndoorEntityPickedListeners.add(listener);
    }

    @UiThread
    public void removeOnIndoorEntityPickedListener(OnIndoorEntityPickedListener listener) {
        this.m_onIndoorEntityPickedListeners.remove(listener);
    }

    @WorkerThread
    public void notifyIndoorEntityPicked(final IndoorEntityPickedMessage message) {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                for (OnIndoorEntityPickedListener listener : IndoorEntityApi.this.m_onIndoorEntityPickedListeners) {
                    listener.onIndoorEntityPicked(message);
                }
            }
        });
    }

    @WorkerThread
    private native void nativeSetIndoorEntityHighlights(long var1, String var3, List<String> var4, int var5);

    @WorkerThread
    private native void nativeClearIndoorEntityHighlights(long var1, String var3, List<String> var4);

    @WorkerThread
    private native void nativeClearAllIndoorEntityHighlights(long var1);
}

