/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.EegeoNativeMapView;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.bluesphere.BlueSphere;
import com.eegeo.mapapi.bluesphere.BlueSphereApi;
import com.eegeo.mapapi.buildings.BuildingHighlight;
import com.eegeo.mapapi.buildings.BuildingHighlightOptions;
import com.eegeo.mapapi.buildings.BuildingsApi;
import com.eegeo.mapapi.camera.CameraAnimationOptions;
import com.eegeo.mapapi.camera.CameraApi;
import com.eegeo.mapapi.camera.CameraPosition;
import com.eegeo.mapapi.camera.CameraUpdate;
import com.eegeo.mapapi.camera.CameraUpdateFactory;
import com.eegeo.mapapi.camera.Projection;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.LatLngAlt;
import com.eegeo.mapapi.indoorentities.IndoorEntityApi;
import com.eegeo.mapapi.indoorentities.IndoorEntityPickedMessage;
import com.eegeo.mapapi.indoorentities.IndoorMapEntityInformation;
import com.eegeo.mapapi.indoorentities.IndoorMapEntityInformationApi;
import com.eegeo.mapapi.indoorentities.OnIndoorEntityPickedListener;
import com.eegeo.mapapi.indoorentities.OnIndoorMapEntityInformationChangedListener;
import com.eegeo.mapapi.indoors.ExpandFloorsJniCalls;
import com.eegeo.mapapi.indoors.IndoorMap;
import com.eegeo.mapapi.indoors.IndoorsApiJniCalls;
import com.eegeo.mapapi.indoors.OnFloorChangedListener;
import com.eegeo.mapapi.indoors.OnIndoorEnteredListener;
import com.eegeo.mapapi.indoors.OnIndoorExitedListener;
import com.eegeo.mapapi.map.EegeoMapOptions;
import com.eegeo.mapapi.map.OnInitialStreamingCompleteListener;
import com.eegeo.mapapi.markers.Marker;
import com.eegeo.mapapi.markers.MarkerApi;
import com.eegeo.mapapi.markers.MarkerOptions;
import com.eegeo.mapapi.markers.OnMarkerClickListener;
import com.eegeo.mapapi.paths.PathApi;
import com.eegeo.mapapi.paths.PointOnPath;
import com.eegeo.mapapi.paths.PointOnRoute;
import com.eegeo.mapapi.paths.PointOnRouteOptions;
import com.eegeo.mapapi.picking.PickResult;
import com.eegeo.mapapi.picking.PickingApi;
import com.eegeo.mapapi.polygons.Polygon;
import com.eegeo.mapapi.polygons.PolygonApi;
import com.eegeo.mapapi.polygons.PolygonOptions;
import com.eegeo.mapapi.polylines.Polyline;
import com.eegeo.mapapi.polylines.PolylineApi;
import com.eegeo.mapapi.polylines.PolylineOptions;
import com.eegeo.mapapi.positioner.OnPositionerChangedListener;
import com.eegeo.mapapi.positioner.Positioner;
import com.eegeo.mapapi.positioner.PositionerApi;
import com.eegeo.mapapi.positioner.PositionerOptions;
import com.eegeo.mapapi.precaching.OnPrecacheOperationCompletedListener;
import com.eegeo.mapapi.precaching.PrecacheApi;
import com.eegeo.mapapi.precaching.PrecacheOperation;
import com.eegeo.mapapi.precaching.PrecacheOperationResult;
import com.eegeo.mapapi.rendering.RenderingApi;
import com.eegeo.mapapi.rendering.RenderingState;
import com.eegeo.mapapi.services.mapscene.Mapscene;
import com.eegeo.mapapi.services.mapscene.MapsceneApi;
import com.eegeo.mapapi.services.mapscene.MapsceneService;
import com.eegeo.mapapi.services.poi.PoiApi;
import com.eegeo.mapapi.services.poi.PoiSearchResult;
import com.eegeo.mapapi.services.poi.PoiService;
import com.eegeo.mapapi.services.routing.Route;
import com.eegeo.mapapi.services.routing.RoutingApi;
import com.eegeo.mapapi.services.routing.RoutingQueryResponse;
import com.eegeo.mapapi.services.routing.RoutingService;
import com.eegeo.mapapi.services.tag.TagApi;
import com.eegeo.mapapi.services.tag.TagService;
import com.eegeo.mapapi.util.Callbacks;
import com.eegeo.mapapi.util.Promise;
import com.eegeo.mapapi.util.Ready;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class EegeoMap {
    private final long m_eegeoMapApiPtr;
    private final INativeMessageRunner m_nativeRunner;
    private final IUiMessageRunner m_uiRunner;
    private List<OnCameraMoveListener> m_onCameraMoveListeners = new ArrayList<OnCameraMoveListener>();
    private List<OnMapClickListener> m_onMapClickedListeners = new ArrayList<OnMapClickListener>();
    private List<OnIndoorEnteredListener> m_onIndoorEnteredListeners = new ArrayList<OnIndoorEnteredListener>();
    private List<OnIndoorExitedListener> m_onIndoorExitedListeners = new ArrayList<OnIndoorExitedListener>();
    private List<OnFloorChangedListener> m_onIndoorFloorChangedListeners = new ArrayList<OnFloorChangedListener>();
    private List<OnInitialStreamingCompleteListener> m_onInitialStreamingCompleteListeners = new ArrayList<OnInitialStreamingCompleteListener>();
    private CameraPosition m_cameraPosition = null;
    private IndoorMap m_indoorMap = null;
    private int m_currentIndoorFloor = -1;
    private Projection m_projection;
    private CameraApi m_cameraApi;
    private MarkerApi m_markerApi;
    private PositionerApi m_positionerApi;
    private PolygonApi m_polygonApi;
    private PolylineApi m_polylineApi;
    private BlueSphereApi m_blueSphereApi;
    private BuildingsApi m_buildingsApi;
    private PickingApi m_pickingApi;
    private RenderingApi m_renderingApi;
    private RenderingState m_renderingState;
    private PoiApi m_poiApi;
    private TagApi m_tagApi;
    private MapsceneApi m_mapsceneApi;
    private RoutingApi m_routingApi;
    private PathApi m_pathApi;
    private BlueSphere m_blueSphere = null;
    private PrecacheApi m_precacheApi;
    private IndoorEntityApi m_indoorEntityApi;
    private IndoorMapEntityInformationApi m_indoorMapEntityInformationApi;
    private static final AllowApiAccess m_allowApiAccess = new AllowApiAccess();

    @WorkerThread
    EegeoMap(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, EegeoNativeMapView.ICreateEegeoMapApi createNativeEegeoMapApi, EegeoMapOptions eegeoMapOptions) {
        this.m_uiRunner = uiRunner;
        this.m_nativeRunner = nativeRunner;
        this.m_eegeoMapApiPtr = createNativeEegeoMapApi.create(this, eegeoMapOptions);
        this.m_projection = new Projection(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_cameraApi = new CameraApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_markerApi = new MarkerApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_positionerApi = new PositionerApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_polygonApi = new PolygonApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_polylineApi = new PolylineApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_blueSphereApi = new BlueSphereApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_buildingsApi = new BuildingsApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_pickingApi = new PickingApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_renderingApi = new RenderingApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        boolean mapCollapsed = false;
        this.m_renderingState = new RenderingState(this.m_renderingApi, m_allowApiAccess, mapCollapsed);
        this.m_poiApi = new PoiApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_tagApi = new TagApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_mapsceneApi = new MapsceneApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_routingApi = new RoutingApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_pathApi = new PathApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_precacheApi = new PrecacheApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_indoorEntityApi = new IndoorEntityApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
        this.m_indoorMapEntityInformationApi = new IndoorMapEntityInformationApi(this.m_nativeRunner, this.m_uiRunner, this.m_eegeoMapApiPtr);
    }

    @WorkerThread
    void initialise(@NonNull EegeoMapOptions eegeoMapOptions) {
        this.m_cameraPosition = new CameraPosition.Builder(eegeoMapOptions.getCamera()).build();
        this.initLocation(this.m_cameraPosition);
    }

    @UiThread
    public void moveCamera(final @NonNull CameraUpdate update) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EegeoMap.this.m_cameraApi.moveCamera(update);
            }
        });
    }

    @UiThread
    public void animateCamera(@NonNull CameraUpdate update, int durationMs) {
        CameraAnimationOptions animationOptions = new CameraAnimationOptions.Builder().duration((double)durationMs / 1000.0).build();
        this.animateCamera(update, animationOptions);
    }

    @UiThread
    public void animateCamera(final @NonNull CameraUpdate update, final CameraAnimationOptions animationOptions) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EegeoMap.this.m_cameraApi.animateCamera(update, animationOptions);
            }
        });
    }

    @WorkerThread
    private void initLocation(@NonNull CameraPosition cameraPosition) {
        this.m_cameraApi.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
    }

    @UiThread
    public Projection getProjection() {
        return this.m_projection;
    }

    @UiThread
    public void stopAnimation() {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                EegeoMap.this.m_cameraApi.cancelAnimation();
            }
        });
    }

    @UiThread
    public void addOnCameraMoveListener(@NonNull OnCameraMoveListener listener) {
        this.m_onCameraMoveListeners.add(listener);
    }

    @UiThread
    public void removeOnCameraMoveListener(@NonNull OnCameraMoveListener listener) {
        this.m_onCameraMoveListeners.remove(listener);
    }

    @UiThread
    public void addOnMapClickListener(@NonNull OnMapClickListener listener) {
        this.m_onMapClickedListeners.add(listener);
    }

    @UiThread
    public void removeOnMapClickListener(@NonNull OnMapClickListener listener) {
        this.m_onMapClickedListeners.remove(listener);
    }

    @UiThread
    public final CameraPosition getCameraPosition() {
        return this.m_cameraPosition;
    }

    @UiThread
    public void setCameraPosition(@NonNull CameraPosition cameraPosition) {
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
    }

    @UiThread
    public void onTapped(Point point) {
        this.m_projection.fromScreenLocation(point).then(new Ready<LatLngAlt>(){

            @Override
            @UiThread
            public void ready(LatLngAlt latLngAlt) {
                for (OnMapClickListener listener : EegeoMap.this.m_onMapClickedListeners) {
                    listener.onMapClick(latLngAlt);
                }
            }
        });
    }

    @WorkerThread
    private void jniOnCameraMove() {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                for (OnCameraMoveListener listener : EegeoMap.this.m_onCameraMoveListeners) {
                    listener.onCameraMove();
                }
            }
        });
    }

    @WorkerThread
    private void jniSetCameraPosition(final CameraPosition cameraPosition) {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                EegeoMap.this.m_cameraPosition = cameraPosition;
            }
        });
    }

    @UiThread
    public void expandIndoor() {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                ExpandFloorsJniCalls.expandIndoor(EegeoMap.this.m_eegeoMapApiPtr);
            }
        });
    }

    @UiThread
    public void collapseIndoor() {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                ExpandFloorsJniCalls.collapseIndoor(EegeoMap.this.m_eegeoMapApiPtr);
            }
        });
    }

    @UiThread
    public IndoorMap getActiveIndoorMap() {
        return this.m_indoorMap;
    }

    @UiThread
    public int getCurrentFloorIndex() {
        return this.m_currentIndoorFloor;
    }

    @UiThread
    public void addOnIndoorEnteredListener(@NonNull OnIndoorEnteredListener listener) {
        this.m_onIndoorEnteredListeners.add(listener);
    }

    @UiThread
    public void removeOnIndoorEnteredListener(@NonNull OnIndoorEnteredListener listener) {
        this.m_onIndoorEnteredListeners.remove(listener);
    }

    @WorkerThread
    private void jniOnIndoorEntered() {
        final IndoorMap indoorMap = IndoorsApiJniCalls.getIndoorMapData(this.m_eegeoMapApiPtr);
        final int currentIndoorFloor = IndoorsApiJniCalls.getCurrentFloorIndex(this.m_eegeoMapApiPtr);
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                EegeoMap.this.m_indoorMap = indoorMap;
                EegeoMap.this.m_currentIndoorFloor = currentIndoorFloor;
                for (OnIndoorEnteredListener listener : EegeoMap.this.m_onIndoorEnteredListeners) {
                    listener.onIndoorEntered();
                }
            }
        });
    }

    @UiThread
    public void addOnIndoorExitedListener(@NonNull OnIndoorExitedListener listener) {
        this.m_onIndoorExitedListeners.add(listener);
    }

    @UiThread
    public void removeOnIndoorExitedListener(@NonNull OnIndoorExitedListener listener) {
        this.m_onIndoorExitedListeners.remove(listener);
    }

    @Deprecated
    @UiThread
    public void onExitIndoorClicked() {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                IndoorsApiJniCalls.exitIndoorMap(EegeoMap.this.m_eegeoMapApiPtr);
            }
        });
    }

    @UiThread
    public void exitIndoorMap() {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                IndoorsApiJniCalls.exitIndoorMap(EegeoMap.this.m_eegeoMapApiPtr);
            }
        });
    }

    @UiThread
    public void enterIndoorMap(final String indoorMapId) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                IndoorsApiJniCalls.enterIndoorMap(EegeoMap.this.m_eegeoMapApiPtr, indoorMapId);
            }
        });
    }

    @WorkerThread
    private void jniOnIndoorExited() {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EegeoMap.this.m_indoorMap = null;
                EegeoMap.this.m_currentIndoorFloor = -1;
                for (OnIndoorExitedListener listener : EegeoMap.this.m_onIndoorExitedListeners) {
                    listener.onIndoorExited();
                }
            }
        });
    }

    @WorkerThread
    private void jniOnIndoorEnterFailed() {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EegeoMap.this.m_indoorMap = null;
                EegeoMap.this.m_currentIndoorFloor = -1;
            }
        });
    }

    @UiThread
    public void setIndoorFloor(final int selectedFloor) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                IndoorsApiJniCalls.floorSelected(EegeoMap.this.m_eegeoMapApiPtr, selectedFloor);
            }
        });
    }

    @UiThread
    public void moveIndoorUp() {
        this.moveIndoorUp(1);
    }

    @UiThread
    public void moveIndoorUp(int numberOfFloors) {
        this.moveIndoorFloors(numberOfFloors);
    }

    @UiThread
    public void moveIndoorDown() {
        this.moveIndoorDown(1);
    }

    @UiThread
    public void moveIndoorDown(int numberOfFloors) {
        this.moveIndoorFloors(-numberOfFloors);
    }

    private void moveIndoorFloors(final int delta) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                EegeoMap.this.m_currentIndoorFloor = IndoorsApiJniCalls.getCurrentFloorIndex(EegeoMap.this.m_eegeoMapApiPtr);
                IndoorsApiJniCalls.floorSelected(EegeoMap.this.m_eegeoMapApiPtr, EegeoMap.this.m_currentIndoorFloor + delta);
            }
        });
    }

    @UiThread
    public void setIndoorFloorInterpolation(final float dragParameter) {
        this.m_nativeRunner.runOnNativeThread(new Runnable(){

            @Override
            public void run() {
                IndoorsApiJniCalls.floorSelectionDragged(EegeoMap.this.m_eegeoMapApiPtr, dragParameter);
            }
        });
    }

    @UiThread
    public void addOnFloorChangedListener(@NonNull OnFloorChangedListener listener) {
        this.m_onIndoorFloorChangedListeners.add(listener);
    }

    @UiThread
    public void removeOnFloorChangedListener(@NonNull OnFloorChangedListener listener) {
        this.m_onIndoorFloorChangedListeners.remove(listener);
    }

    @WorkerThread
    private void jniOnFloorChanged(final int selectedFloor) {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                EegeoMap.this.m_currentIndoorFloor = selectedFloor;
                for (OnFloorChangedListener listener : EegeoMap.this.m_onIndoorFloorChangedListeners) {
                    listener.onFloorChanged(EegeoMap.this.m_currentIndoorFloor);
                }
            }
        });
    }

    @UiThread
    public Marker addMarker(@NonNull MarkerOptions markerOptions) {
        return new Marker(this.m_markerApi, markerOptions);
    }

    @UiThread
    public void removeMarker(@NonNull Marker marker) {
        marker.destroy();
    }

    @UiThread
    public Positioner addPositioner(@NonNull PositionerOptions positionerOptions) {
        return new Positioner(this.m_positionerApi, positionerOptions);
    }

    @UiThread
    public void removePositioner(@NonNull Positioner positioner) {
        positioner.destroy();
    }

    @UiThread
    public Polygon addPolygon(@NonNull PolygonOptions polygonOptions) {
        return new Polygon(this.m_polygonApi, polygonOptions);
    }

    @UiThread
    public void removePolygon(@NonNull Polygon polygon) {
        polygon.destroy();
    }

    @UiThread
    public Polyline addPolyline(@NonNull PolylineOptions polylineOptions) {
        return new Polyline(this.m_polylineApi, polylineOptions);
    }

    @UiThread
    public void removePolyline(@NonNull Polyline polyline) {
        polyline.destroy();
    }

    @UiThread
    public BuildingHighlight addBuildingHighlight(@NonNull BuildingHighlightOptions buildingHighlightOptions) {
        return new BuildingHighlight(this.m_buildingsApi, buildingHighlightOptions);
    }

    @UiThread
    public void removeBuildingHighlight(@NonNull BuildingHighlight buildingHighlight) {
        buildingHighlight.destroy();
    }

    @UiThread
    public Promise<PickResult> pickFeatureAtScreenPoint(@NonNull Point point) {
        return this.m_pickingApi.pickFeatureAtScreenPoint(point);
    }

    @UiThread
    public Promise<PickResult> pickFeatureAtLatLng(@NonNull LatLng latLng) {
        return this.m_pickingApi.pickFeatureAtLatLng(latLng);
    }

    @UiThread
    public BlueSphere getBlueSphere() {
        if (this.m_blueSphere == null) {
            this.m_blueSphere = new BlueSphere(this.m_blueSphereApi);
        }
        return this.m_blueSphere;
    }

    @UiThread
    public void setMapCollapsed(boolean isCollapsed) {
        this.m_renderingState.setMapCollapsed(isCollapsed);
    }

    @UiThread
    public boolean isMapCollapsed() {
        return this.m_renderingState.isMapCollapsed();
    }

    public void setIndoorEntityHighlights(String indoorMapId, Collection<String> indoorEntityIds, int highlightColorARGB) {
        ArrayList<String> indoorEntityIdsList = new ArrayList<String>(indoorEntityIds);
        this.m_indoorEntityApi.setIndoorEntityHighlights(indoorMapId, indoorEntityIdsList, highlightColorARGB);
    }

    public void clearIndoorEntityHighlights(String indoorMapId, Collection<String> indoorEntityIds) {
        ArrayList<String> indoorEntityIdsList = new ArrayList<String>(indoorEntityIds);
        this.m_indoorEntityApi.clearIndoorEntityHighlights(indoorMapId, indoorEntityIdsList);
    }

    public void clearAllIndoorEntityHighlights() {
        this.m_indoorEntityApi.clearAllIndoorEntityHighlights();
    }

    public IndoorMapEntityInformation addIndoorMapEntityInformation(@NonNull String indoorMapId, OnIndoorMapEntityInformationChangedListener indoorMapEntityInformationChangedListener) {
        return new IndoorMapEntityInformation(this.m_indoorMapEntityInformationApi, indoorMapId, indoorMapEntityInformationChangedListener);
    }

    public void removeIndoorMapEntityInformation(@NonNull IndoorMapEntityInformation indoorMapEntityInformation) {
        indoorMapEntityInformation.destroy();
    }

    @UiThread
    public PoiService createPoiService() {
        PoiService poiService = new PoiService(this.m_poiApi);
        return poiService;
    }

    @UiThread
    public TagService createTagService() {
        TagService tagService = new TagService(this.m_tagApi);
        return tagService;
    }

    public MapsceneService createMapsceneService() {
        MapsceneService mapsceneService = new MapsceneService(this.m_mapsceneApi, this);
        return mapsceneService;
    }

    @UiThread
    public RoutingService createRoutingService() {
        RoutingService routingService = new RoutingService(this.m_routingApi);
        return routingService;
    }

    @UiThread
    public void addMarkerClickListener(@NonNull OnMarkerClickListener listener) {
        this.m_markerApi.addMarkerClickListener(listener);
    }

    @UiThread
    public void removeMarkerClickListener(@NonNull OnMarkerClickListener listener) {
        this.m_markerApi.removeMarkerClickListener(listener);
    }

    @UiThread
    public void addPositionerChangedListener(@NonNull OnPositionerChangedListener listener) {
        this.m_positionerApi.addPositionerChangedListener(listener);
    }

    @UiThread
    public void removePositionerChangedListener(@NonNull OnPositionerChangedListener listener) {
        this.m_positionerApi.removePositionerChangedListener(listener);
    }

    @UiThread
    public void addOnIndoorEntityPickedListener(@NonNull OnIndoorEntityPickedListener listener) {
        this.m_indoorEntityApi.addOnIndoorEntityPickedListener(listener);
    }

    @UiThread
    public void removeOnIndoorEntityPickedListener(@NonNull OnIndoorEntityPickedListener listener) {
        this.m_indoorEntityApi.removeOnIndoorEntityPickedListener(listener);
    }

    @UiThread
    public PrecacheOperation precache(LatLng center, double radius, OnPrecacheOperationCompletedListener callback) throws IllegalArgumentException {
        double maximumPrecacheRadius = this.m_precacheApi.getMaximumPrecacheRadius();
        if (radius < 0.0 || radius > maximumPrecacheRadius) {
            throw new IllegalArgumentException(String.format("radius %f outside of valid (0, %f] range.", radius, maximumPrecacheRadius));
        }
        return this.m_precacheApi.precache(center, radius, callback);
    }

    @UiThread
    public double getMaximumPrecacheRadius() {
        return this.m_precacheApi.getMaximumPrecacheRadius();
    }

    @WorkerThread
    private void jniOnMarkerClicked(int markerId) {
        this.m_markerApi.notifyMarkerClicked(markerId);
    }

    @WorkerThread
    private void jniOnBuildingInformationReceived(int buildingHighlightId) {
        this.m_buildingsApi.notifyBuildingInformationReceived(buildingHighlightId);
    }

    @WorkerThread
    private void jniOnPositionerProjectionChanged() {
        this.m_positionerApi.notifyProjectionChanged();
    }

    @WorkerThread
    private void jniOnPoiSearchCompleted(int poiSearchId, boolean succeeded, List<PoiSearchResult> searchResults) {
        this.m_poiApi.notifySearchComplete(poiSearchId, succeeded, searchResults);
    }

    @WorkerThread
    private void jniOnMapsceneRequestCompleted(int mapsceneRequestId, boolean succeeded, Mapscene mapscene) {
        this.m_mapsceneApi.notifyRequestComplete(mapsceneRequestId, succeeded, mapscene);
    }

    @WorkerThread
    private void jniOnSearchTagsLoaded() {
        this.m_tagApi.notifyTagsLoaded();
    }

    @WorkerThread
    private void jniOnPrecacheQueryCompleted(int precacheOperationId, PrecacheOperationResult result) {
        this.m_precacheApi.notifyPrecacheOperationComplete(precacheOperationId, result);
    }

    @WorkerThread
    private void jniOnRoutingQueryCompleted(int routingQueryId, RoutingQueryResponse response) {
        this.m_routingApi.notifyQueryComplete(routingQueryId, response);
    }

    @WorkerThread
    private void jniOnIndoorEntityPicked(IndoorEntityPickedMessage message) {
        this.m_indoorEntityApi.notifyIndoorEntityPicked(message);
    }

    @WorkerThread
    private void jniOnIndoorMapEntityInformationChanged(int indoorMapEntityInformationId) {
        this.m_indoorMapEntityInformationApi.notifyIndoorMapEntityInformationChanged(indoorMapEntityInformationId);
    }

    @UiThread
    public void addInitialStreamingCompleteListener(@NonNull OnInitialStreamingCompleteListener listener) {
        this.m_onInitialStreamingCompleteListeners.add(listener);
    }

    @UiThread
    public void removeInitialStreamingCompleteListener(@NonNull OnInitialStreamingCompleteListener listener) {
        this.m_onInitialStreamingCompleteListeners.remove(listener);
    }

    @WorkerThread
    private void jniNotifyInitialStreamingComplete() {
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            @UiThread
            public void run() {
                for (OnInitialStreamingCompleteListener listener : EegeoMap.this.m_onInitialStreamingCompleteListeners) {
                    listener.onInitialStreamingComplete();
                }
            }
        });
    }

    @UiThread
    public Promise<PointOnRoute> getPointOnRoute(LatLng point, Route route, PointOnRouteOptions pointOnRouteOptions) {
        return this.m_pathApi.getPointOnRoute(point, route, pointOnRouteOptions);
    }

    @UiThread
    public Promise<PointOnPath> getPointOnPath(LatLng point, List<LatLng> path) {
        return this.m_pathApi.getPointOnPath(point, path);
    }

    public static final class AllowApiAccess {
        @WorkerThread
        private AllowApiAccess() {
        }
    }

    private class OnCameraMoveListenerImpl
    implements Callbacks.ICallback0 {
        private OnCameraMoveListener m_listener;

        @UiThread
        public OnCameraMoveListenerImpl(OnCameraMoveListener listener) {
            this.m_listener = listener;
        }

        @Override
        @UiThread
        public void onCallback() {
            this.m_listener.onCameraMove();
        }
    }

    public static interface OnMapClickListener {
        @UiThread
        public void onMapClick(LatLngAlt var1);
    }

    public static interface OnCameraMoveListener {
        @UiThread
        public void onCameraMove();
    }
}

