/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.paymentlinks;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CreatePaymentLinkRequest;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.PaymentLinkResponse;
import com.onlinepayments.merchant.paymentlinks.PaymentLinksClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class PaymentLinksClient
extends ApiResource
implements PaymentLinksClientInterface {
    public PaymentLinksClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public PaymentLinkResponse createPaymentLink(CreatePaymentLinkRequest body) {
        return this.createPaymentLink(body, null);
    }

    @Override
    public PaymentLinkResponse createPaymentLink(CreatePaymentLinkRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/paymentlinks", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, PaymentLinkResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentLinkResponse getPaymentLinkById(String paymentLinkId) {
        return this.getPaymentLinkById(paymentLinkId, null);
    }

    @Override
    public PaymentLinkResponse getPaymentLinkById(String paymentLinkId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentLinkId", paymentLinkId);
        String uri = this.instantiateUri("/v2/{merchantId}/paymentlinks/{paymentLinkId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PaymentLinkResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public void cancelPaymentLinkById(String paymentLinkId) {
        this.cancelPaymentLinkById(paymentLinkId, null);
    }

    @Override
    public void cancelPaymentLinkById(String paymentLinkId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentLinkId", paymentLinkId);
        String uri = this.instantiateUri("/v2/{merchantId}/paymentlinks/{paymentLinkId}/cancel", pathContext);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, null, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

