/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.logging;

import com.onlinepayments.logging.LoggingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class LogMessageBuilder {
    private final String requestId;
    private final StringBuilder headers;
    private String body;
    private String contentType;

    protected LogMessageBuilder(String requestId) {
        if (requestId == null || requestId.isEmpty()) {
            throw new IllegalArgumentException("requestId is required");
        }
        this.requestId = requestId;
        this.headers = new StringBuilder();
    }

    protected final String requestId() {
        return this.requestId;
    }

    protected final String headers() {
        return this.headers.toString();
    }

    protected final String body() {
        return this.body;
    }

    protected final String contentType() {
        return this.contentType;
    }

    public final void addHeader(String name, String value) {
        if (this.headers.length() > 0) {
            this.headers.append(", ");
        }
        this.headers.append(name);
        this.headers.append("=\"");
        if (value != null) {
            String obfuscatedValue = LoggingUtil.obfuscateHeader(name, value);
            this.headers.append(obfuscatedValue);
        }
        this.headers.append("\"");
    }

    public final void setBody(String body, String contentType) {
        this.body = LoggingUtil.obfuscateBody(body);
        this.contentType = contentType;
    }

    public final void setBody(InputStream bodyStream, Charset charset, String contentType) throws IOException {
        this.body = LoggingUtil.obfuscateBody(bodyStream, charset);
        this.contentType = contentType;
    }

    public final void setBody(Reader bodyStream, String contentType) throws IOException {
        this.body = LoggingUtil.obfuscateBody(bodyStream);
        this.contentType = contentType;
    }

    public abstract String getMessage();

    protected final String emptyIfNull(String value) {
        return value != null ? value : "";
    }
}

