/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.defaultimpl;

import com.onlinepayments.CommunicationException;
import com.onlinepayments.CommunicatorConfiguration;
import com.onlinepayments.PooledConnection;
import com.onlinepayments.ProxyConfiguration;
import com.onlinepayments.RequestHeader;
import com.onlinepayments.ResponseHandler;
import com.onlinepayments.ResponseHeader;
import com.onlinepayments.defaultimpl.JsonEntity;
import com.onlinepayments.logging.CommunicatorLogger;
import com.onlinepayments.logging.LogMessageBuilder;
import com.onlinepayments.logging.RequestLogMessageBuilder;
import com.onlinepayments.logging.ResponseLogMessageBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

public class DefaultConnection
implements PooledConnection {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String REQUEST_ID_ATTRIBUTE = DefaultConnection.class.getName() + ".requestId";
    private static final String START_TIMME_ATTRIBUTE = DefaultConnection.class.getName() + ".startTme";
    protected final CloseableHttpClient httpClient;
    private final HttpClientConnectionManager connectionManager;
    protected final RequestConfig requestConfig;
    private volatile CommunicatorLogger communicatorLogger;

    public DefaultConnection() {
        this(10000, 10000);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout) {
        this(connectTimeout, socketTimeout, null);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections) {
        this(connectTimeout, socketTimeout, maxConnections, null);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, ProxyConfiguration proxyConfiguration) {
        this(connectTimeout, socketTimeout, 10, proxyConfiguration);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections, ProxyConfiguration proxyConfiguration) {
        this(connectTimeout, socketTimeout, maxConnections, proxyConfiguration, CommunicatorConfiguration.DEFAULT_HTTPS_PROTOCOLS);
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections, ProxyConfiguration proxyConfiguration, Set<String> httpsProtocols) {
        this(connectTimeout, socketTimeout, maxConnections, proxyConfiguration, DefaultConnection.createSSLConnectionSocketFactory(httpsProtocols));
    }

    public DefaultConnection(int connectTimeout, int socketTimeout, int maxConnections, ProxyConfiguration proxyConfiguration, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        if (sslConnectionSocketFactory == null) {
            throw new IllegalArgumentException("sslConnectionSocketFactory is required");
        }
        this.requestConfig = this.createRequestConfig(connectTimeout, socketTimeout);
        this.connectionManager = this.createHttpClientConnectionManager(maxConnections, sslConnectionSocketFactory);
        this.httpClient = this.createHttpClient(proxyConfiguration);
    }

    private static SSLConnectionSocketFactory createSSLConnectionSocketFactory(Set<String> httpsProtocols) {
        SSLContext sslContext = SSLContexts.createDefault();
        HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        Set<String> supportedProtocols = httpsProtocols != null && !httpsProtocols.isEmpty() ? httpsProtocols : CommunicatorConfiguration.DEFAULT_HTTPS_PROTOCOLS;
        return new SSLConnectionSocketFactory(sslContext, supportedProtocols.toArray(new String[0]), null, hostnameVerifier);
    }

    private RequestConfig createRequestConfig(int connectTimeout, int socketTimeout) {
        return RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
    }

    private HttpClientConnectionManager createHttpClientConnectionManager(int maxConnections, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
        connectionManager.setMaxTotal(maxConnections + 20);
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(ProxyConfiguration proxyConfiguration) {
        SystemDefaultCredentialsProvider credentialsProvider;
        SystemDefaultRoutePlanner routePlanner;
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.connectionManager);
        if (proxyConfiguration != null) {
            HttpHost proxy = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort(), proxyConfiguration.getScheme());
            routePlanner = new DefaultProxyRoutePlanner(proxy, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
            credentialsProvider = new BasicCredentialsProvider();
            if (proxyConfiguration.getUsername() != null) {
                AuthScope authscope = new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword());
                credentialsProvider.setCredentials(authscope, (Credentials)credentials);
                HttpRequestInterceptor proxyAuthenticationInterceptor = new HttpRequestInterceptor((Credentials)credentials){
                    final /* synthetic */ Credentials val$credentials;
                    {
                        this.val$credentials = credentials;
                    }

                    public void process(HttpRequest request, HttpContext context) throws HttpException {
                        Header header = request.getFirstHeader("Proxy-Authorization");
                        if (header == null) {
                            header = new BasicScheme((Charset)null).authenticate(this.val$credentials, request, context);
                            if (!"Proxy-Authorization".equals(header.getName())) {
                                header = new BasicHeader("Proxy-Authorization", header.getValue());
                            }
                            request.setHeader(header);
                        }
                    }
                };
                builder.addInterceptorLast(proxyAuthenticationInterceptor);
            }
        } else {
            routePlanner = new SystemDefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE, ProxySelector.getDefault());
            credentialsProvider = new SystemDefaultCredentialsProvider();
        }
        LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
        return builder.addInterceptorLast((HttpRequestInterceptor)loggingInterceptor).addInterceptorFirst((HttpResponseInterceptor)loggingInterceptor).setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    public <R> R get(URI uri, List<RequestHeader> requestHeaders, ResponseHandler<R> responseHandler) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpGet, requestHeaders);
        return this.executeRequest((HttpUriRequest)httpGet, responseHandler);
    }

    @Override
    public <R> R delete(URI uri, List<RequestHeader> requestHeaders, ResponseHandler<R> responseHandler) {
        HttpDelete httpDelete = new HttpDelete(uri);
        httpDelete.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpDelete, requestHeaders);
        return this.executeRequest((HttpUriRequest)httpDelete, responseHandler);
    }

    @Override
    public <R> R post(URI uri, List<RequestHeader> requestHeaders, String body, ResponseHandler<R> responseHandler) {
        HttpEntity requestEntity = this.createRequestEntity(body);
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpPost, requestHeaders);
        if (requestEntity != null) {
            httpPost.setEntity(requestEntity);
        }
        return this.executeRequest((HttpUriRequest)httpPost, responseHandler);
    }

    @Override
    public <R> R put(URI uri, List<RequestHeader> requestHeaders, String body, ResponseHandler<R> responseHandler) {
        HttpEntity requestEntity = this.createRequestEntity(body);
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setConfig(this.requestConfig);
        this.addHeaders((HttpRequestBase)httpPut, requestHeaders);
        if (requestEntity != null) {
            httpPut.setEntity(requestEntity);
        }
        return this.executeRequest((HttpUriRequest)httpPut, responseHandler);
    }

    private HttpEntity createRequestEntity(String body) {
        return body != null ? new JsonEntity(body, CHARSET) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R> R executeRequest(HttpUriRequest request, ResponseHandler<R> responseHandler) {
        String requestId = UUID.randomUUID().toString();
        long startTime = System.currentTimeMillis();
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute(REQUEST_ID_ATTRIBUTE, (Object)requestId);
        context.setAttribute(START_TIMME_ATTRIBUTE, (Object)startTime);
        boolean logRuntimeExceptions = true;
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute(request, (HttpContext)context);
            HttpEntity entity = httpResponse.getEntity();
            Object bodyStream = EmptyInputStream.INSTANCE;
            try {
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                List<ResponseHeader> headers = this.getHeaders((HttpResponse)httpResponse);
                InputStream inputStream = bodyStream = entity == null ? null : entity.getContent();
                if (bodyStream == null) {
                    bodyStream = EmptyInputStream.INSTANCE;
                }
                logRuntimeExceptions = false;
                R r = responseHandler.handleResponse(statusCode, (InputStream)bodyStream, headers);
                return r;
            }
            finally {
                ((InputStream)bodyStream).close();
            }
        }
        catch (ClientProtocolException e) {
            this.logError(requestId, (Exception)((Object)e), startTime, this.communicatorLogger);
            throw new CommunicationException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.logError(requestId, e, startTime, this.communicatorLogger);
            throw new CommunicationException(e);
        }
        catch (CommunicationException e) {
            this.logError(requestId, e, startTime, this.communicatorLogger);
            throw e;
        }
        catch (RuntimeException e) {
            if (!logRuntimeExceptions) throw e;
            this.logError(requestId, e, startTime, this.communicatorLogger);
            throw e;
        }
    }

    protected void addHeaders(HttpRequestBase httpRequestBase, List<RequestHeader> requestHeaders) {
        if (requestHeaders != null) {
            for (RequestHeader requestHeader : requestHeaders) {
                httpRequestBase.addHeader((Header)new BasicHeader(requestHeader.getName(), requestHeader.getValue()));
            }
        }
    }

    protected List<ResponseHeader> getHeaders(HttpResponse httpResponse) {
        Header[] headers = httpResponse.getAllHeaders();
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>(headers.length);
        for (Header header : headers) {
            result.add(new ResponseHeader(header.getName(), header.getValue()));
        }
        return result;
    }

    @Override
    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
        this.connectionManager.closeIdleConnections(idleTime, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.connectionManager.closeExpiredConnections();
    }

    @Override
    public void enableLogging(CommunicatorLogger communicatorLogger) {
        if (communicatorLogger == null) {
            throw new IllegalArgumentException("communicatorLogger is required");
        }
        this.communicatorLogger = communicatorLogger;
    }

    @Override
    public void disableLogging() {
        this.communicatorLogger = null;
    }

    private void logRequest(HttpRequest request, String requestId, CommunicatorLogger logger) {
        try {
            RequestLine requestLine = request.getRequestLine();
            String method = requestLine.getMethod();
            String uri = requestLine.getUri();
            RequestLogMessageBuilder logMessageBuilder = new RequestLogMessageBuilder(requestId, method, uri);
            this.addHeaders(logMessageBuilder, request.getAllHeaders());
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)request;
                HttpEntity entity = entityEnclosingRequest.getEntity();
                String contentType = this.getContentType(entity, request.getFirstHeader("Content-Type"));
                if (entity != null && !entity.isRepeatable()) {
                    entity = new BufferedHttpEntity(entity);
                    entityEnclosingRequest.setEntity(entity);
                }
                this.setBody(logMessageBuilder, entity, contentType);
            }
            logger.log(logMessageBuilder.getMessage());
        }
        catch (Exception e) {
            logger.log(String.format("An error occurred trying to log request '%s'", requestId), e);
        }
    }

    private void logResponse(HttpResponse response, String requestId, long startTime, CommunicatorLogger logger) {
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            ResponseLogMessageBuilder logMessageBuilder = new ResponseLogMessageBuilder(requestId, statusCode, duration);
            this.addHeaders(logMessageBuilder, response.getAllHeaders());
            HttpEntity entity = response.getEntity();
            String contentType = this.getContentType(entity, response.getFirstHeader("Content-Type"));
            if (entity != null && !entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
                response.setEntity(entity);
            }
            this.setBody(logMessageBuilder, entity, contentType);
            logger.log(logMessageBuilder.getMessage());
        }
        catch (Exception e) {
            logger.log(String.format("An error occurred trying to log response '%s'", requestId), e);
        }
    }

    private void addHeaders(LogMessageBuilder logMessageBuilder, Header[] headers) {
        if (headers != null) {
            for (Header header : headers) {
                logMessageBuilder.addHeader(header.getName(), header.getValue());
            }
        }
    }

    private String getContentType(HttpEntity entity, Header defaultHeader) {
        Header contentTypeHeader;
        Header header = contentTypeHeader = entity != null ? entity.getContentType() : null;
        if (contentTypeHeader == null) {
            contentTypeHeader = defaultHeader;
        }
        return contentTypeHeader != null ? contentTypeHeader.getValue() : null;
    }

    private void setBody(LogMessageBuilder logMessageBuilder, HttpEntity entity, String contentType) throws IOException {
        if (entity == null) {
            logMessageBuilder.setBody("", contentType);
        } else if (entity instanceof JsonEntity) {
            String body = ((JsonEntity)entity).getString();
            logMessageBuilder.setBody(body, contentType);
        } else {
            logMessageBuilder.setBody(entity.getContent(), CHARSET, contentType);
        }
    }

    private void logError(String requestId, Exception error, long startTime, CommunicatorLogger logger) {
        if (logger != null) {
            String messageTemplate = "Error occurred for outgoing request (requestId='%s', %d ms)";
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            String message = String.format("Error occurred for outgoing request (requestId='%s', %d ms)", requestId, duration);
            logger.log(message, error);
        }
    }

    private class LoggingInterceptor
    implements HttpRequestInterceptor,
    HttpResponseInterceptor {
        private LoggingInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) {
            String requestId;
            CommunicatorLogger logger = DefaultConnection.this.communicatorLogger;
            if (logger != null && (requestId = (String)context.getAttribute(REQUEST_ID_ATTRIBUTE)) != null) {
                DefaultConnection.this.logRequest(request, requestId, logger);
            }
        }

        public void process(HttpResponse response, HttpContext context) {
            CommunicatorLogger logger = DefaultConnection.this.communicatorLogger;
            if (logger != null) {
                String requestId = (String)context.getAttribute(REQUEST_ID_ATTRIBUTE);
                Long startTime = (Long)context.getAttribute(START_TIMME_ATTRIBUTE);
                if (requestId != null && startTime != null) {
                    DefaultConnection.this.logResponse(response, requestId, startTime, logger);
                }
            }
        }
    }
}

