/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.webhooks;

import com.onlinepayments.Marshaller;
import com.onlinepayments.RequestHeader;
import com.onlinepayments.domain.WebhooksEvent;
import com.onlinepayments.webhooks.ApiVersionMismatchException;
import com.onlinepayments.webhooks.SecretKeyStore;
import com.onlinepayments.webhooks.SignatureValidationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class WebhooksHelper {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final Marshaller marshaller;
    private final SecretKeyStore secretKeyStore;

    public WebhooksHelper(Marshaller marshaller, SecretKeyStore secretKeyStore) {
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller is required");
        }
        if (secretKeyStore == null) {
            throw new IllegalArgumentException("secretKeyStore is required");
        }
        this.marshaller = marshaller;
        this.secretKeyStore = secretKeyStore;
    }

    public WebhooksEvent unmarshal(InputStream bodyStream, List<RequestHeader> requestHeaders) throws IOException {
        byte[] bodyBytes = this.getContent(bodyStream);
        return this.unmarshal(bodyBytes, requestHeaders);
    }

    private byte[] getContent(InputStream bodyStream) throws IOException {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((len = bodyStream.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
        return output.toByteArray();
    }

    public WebhooksEvent unmarshal(byte[] body, List<RequestHeader> requestHeaders) {
        this.validate(body, requestHeaders);
        WebhooksEvent event = this.marshaller.unmarshal(new String(body, CHARSET), WebhooksEvent.class);
        this.validateApiVersion(event);
        return event;
    }

    protected void validate(byte[] body, List<RequestHeader> requestHeaders) {
        try {
            this.validateBody(body, requestHeaders);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureValidationException(e);
        }
    }

    public WebhooksEvent unmarshal(String body, List<RequestHeader> requestHeaders) {
        this.validate(body, requestHeaders);
        WebhooksEvent event = this.marshaller.unmarshal(body, WebhooksEvent.class);
        this.validateApiVersion(event);
        return event;
    }

    protected void validate(String body, List<RequestHeader> requestHeaders) {
        this.validate(body.getBytes(CHARSET), requestHeaders);
    }

    private void validateBody(byte[] body, List<RequestHeader> requestHeaders) throws GeneralSecurityException {
        String signature = this.getHeaderValue(requestHeaders, "X-GCS-Signature");
        String keyId = this.getHeaderValue(requestHeaders, "X-GCS-KeyId");
        String secretKey = this.secretKeyStore.getSecretKey(keyId);
        Mac hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(CHARSET), "HmacSHA256");
        hmac.init(key);
        byte[] unencodedResult = hmac.doFinal(body);
        String expectedSignature = Base64.encodeBase64String((byte[])unencodedResult);
        boolean isValid = WebhooksHelper.areEqualSignatures(signature, expectedSignature);
        if (!isValid) {
            throw new SignatureValidationException("failed to validate signature '" + signature + "'");
        }
    }

    static boolean areEqualSignatures(String signature, String expectedSignature) {
        int length = signature.length();
        int expectedLength = expectedSignature.length();
        int limit = Math.max(Math.max(length, expectedLength), 256);
        boolean result = true;
        for (int i = 0; i < limit; ++i) {
            if (i < length && i < expectedLength) {
                result &= signature.charAt(i) == expectedSignature.charAt(i);
                continue;
            }
            result &= i >= length && i >= expectedLength;
        }
        return result;
    }

    private void validateApiVersion(WebhooksEvent event) {
        if (!"v1".equals(event.getApiVersion())) {
            throw new ApiVersionMismatchException(event.getApiVersion(), "v1");
        }
    }

    private String getHeaderValue(List<RequestHeader> requestHeaders, String headerName) {
        String value = null;
        for (RequestHeader header : requestHeaders) {
            if (!headerName.equalsIgnoreCase(header.getName())) continue;
            if (value == null) {
                value = header.getValue();
                continue;
            }
            throw new SignatureValidationException("encountered multiple occurrences of header '" + headerName + "'");
        }
        if (value == null) {
            throw new SignatureValidationException("could not find header '" + headerName + "'");
        }
        return value;
    }
}

