/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.webhooks;

import com.onlinepayments.webhooks.SecretKeyNotAvailableException;
import com.onlinepayments.webhooks.SecretKeyStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class InMemorySecretKeyStore
implements SecretKeyStore {
    public static final InMemorySecretKeyStore INSTANCE = new InMemorySecretKeyStore();
    private final Map<String, String> store = new ConcurrentHashMap<String, String>();

    private InMemorySecretKeyStore() {
    }

    @Override
    public String getSecretKey(String keyId) {
        String secretKey = this.store.get(keyId);
        if (secretKey == null) {
            throw new SecretKeyNotAvailableException("could not find secret key for key id " + keyId, keyId);
        }
        return secretKey;
    }

    public void storeSecretKey(String keyId, String secretKey) {
        if (keyId == null || keyId.trim().isEmpty()) {
            throw new IllegalArgumentException("keyId is required");
        }
        if (secretKey == null || secretKey.trim().isEmpty()) {
            throw new IllegalArgumentException("secretKey is required");
        }
        this.store.put(keyId, secretKey);
    }

    public void removeSecretKey(String keyId) {
        this.store.remove(keyId);
    }

    public void clear() {
        this.store.clear();
    }
}

