/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.defaultimpl;

import com.onlinepayments.Authenticator;
import com.onlinepayments.RequestHeader;
import com.onlinepayments.defaultimpl.AuthorizationType;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class DefaultAuthenticator
implements Authenticator {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final Pattern CANONICALIZE_HEADER_REGEXP = Pattern.compile("\r?\n[\\s&&[^\r\n]]*");
    private static final Comparator<RequestHeader> REQUEST_HEADER_COMPARATOR = new Comparator<RequestHeader>(){

        @Override
        public int compare(RequestHeader header1, RequestHeader header2) {
            return header1.getName().compareTo(header2.getName());
        }
    };
    private final AuthorizationType authorizationType;
    private final String apiKeyId;
    private final String secretApiKey;

    public DefaultAuthenticator(String apiKeyId, String secretApiKey) {
        this(apiKeyId, secretApiKey, AuthorizationType.V1HMAC);
    }

    public DefaultAuthenticator(String apiKeyId, String secretApiKey, AuthorizationType authorizationType) {
        if (secretApiKey == null || secretApiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("secretApiKey is required");
        }
        if (apiKeyId == null || apiKeyId.trim().isEmpty()) {
            throw new IllegalArgumentException("apiKeyId is required");
        }
        this.authorizationType = authorizationType == null ? AuthorizationType.V1HMAC : authorizationType;
        this.apiKeyId = apiKeyId;
        this.secretApiKey = secretApiKey;
    }

    @Override
    public String createSimpleAuthenticationSignature(String httpMethod, URI resourceUri, List<RequestHeader> httpHeaders) {
        if (httpMethod == null || httpMethod.trim().isEmpty()) {
            throw new IllegalArgumentException("httpMethod is required");
        }
        if (resourceUri == null) {
            throw new IllegalArgumentException("resourceUri is required");
        }
        String dataToSign = this.toDataToSign(httpMethod, resourceUri, httpHeaders);
        return "GCS " + this.authorizationType.getSignatureString() + ":" + this.apiKeyId + ":" + this.createAuthenticationSignature(dataToSign);
    }

    String toDataToSign(String httpMethod, URI resourceUri, List<RequestHeader> httpHeaders) {
        String contentType = null;
        String date = null;
        String canonicalizedResource = this.toCanonicalizedResource(resourceUri);
        ArrayList<RequestHeader> xgcsHttpHeaders = new ArrayList<RequestHeader>();
        if (httpHeaders != null) {
            for (RequestHeader httpHeader : httpHeaders) {
                if ("Content-Type".equalsIgnoreCase(httpHeader.getName())) {
                    contentType = httpHeader.getValue();
                    continue;
                }
                if ("Date".equalsIgnoreCase(httpHeader.getName())) {
                    date = httpHeader.getValue();
                    continue;
                }
                String name = this.toCanonicalizeHeaderName(httpHeader.getName());
                if (!name.startsWith("x-gcs")) continue;
                String value = this.toCanonicalizeHeaderValue(httpHeader.getValue());
                RequestHeader xgcsHttpHeader = new RequestHeader(name, value);
                xgcsHttpHeaders.add(xgcsHttpHeader);
            }
        }
        Collections.sort(xgcsHttpHeaders, REQUEST_HEADER_COMPARATOR);
        StringBuilder sb = new StringBuilder(100);
        sb.append(httpMethod.toUpperCase()).append('\n');
        if (contentType != null) {
            sb.append(contentType).append('\n');
        } else {
            sb.append('\n');
        }
        sb.append(date).append('\n');
        for (RequestHeader xgcsHttpHeader : xgcsHttpHeaders) {
            sb.append(xgcsHttpHeader.getName()).append(':').append(xgcsHttpHeader.getValue()).append('\n');
        }
        sb.append(canonicalizedResource).append('\n');
        return sb.toString();
    }

    private String toCanonicalizedResource(URI resourceUri) {
        String rawPath = resourceUri.getRawPath();
        if (resourceUri.getQuery() == null) {
            return rawPath;
        }
        return rawPath + '?' + resourceUri.getQuery();
    }

    private String toCanonicalizeHeaderName(String originalName) {
        return originalName == null ? null : originalName.toLowerCase(Locale.ENGLISH);
    }

    String toCanonicalizeHeaderValue(String originalValue) {
        if (originalValue == null) {
            return "";
        }
        return CANONICALIZE_HEADER_REGEXP.matcher(originalValue).replaceAll(" ").trim();
    }

    String createAuthenticationSignature(String dataToSign) {
        try {
            Mac sha256Hmac = Mac.getInstance(HMAC_ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(this.secretApiKey.getBytes(CHARSET), HMAC_ALGORITHM);
            sha256Hmac.init(secretKey);
            byte[] unencodedResult = sha256Hmac.doFinal(dataToSign.getBytes(CHARSET));
            return Base64.encodeBase64String((byte[])unencodedResult);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No such HMAC algorithm HmacSHA256", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid HMAC key", e);
        }
    }
}

