/*
 * Decompiled with CFR 0.152.
 */
package com.wordplat.uikit.splash;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import com.wordplat.uikit.splash.R;
import java.lang.ref.WeakReference;

public abstract class AbstractSplashActivity
extends Activity {
    protected int remainSeconds = 3;
    protected int maxSeconds = 3;
    private static final int MSG_TIMER_START = 1;
    private static final int MSG_TIMER_PERIOD = 2;
    private static final int MSG_TIMER_END = 3;
    protected Activity mActivity;
    private Handler timerHandler;
    private Handler timeOutHandler;
    private ImageView adImage;
    private Button continueBut;
    private boolean showContinueBut;

    protected abstract int getLayoutResId();

    protected abstract int getAdImageResId();

    protected abstract int getContinueButResId();

    protected abstract void onTimeEnd();

    protected void startTimer(boolean showContinueBut) {
        this.showContinueBut = showContinueBut;
        this.timerHandler.sendEmptyMessage(1);
    }

    protected void endTimer() {
        this.timerHandler.removeMessages(2);
        this.timeOutHandler.removeMessages(3);
    }

    protected void onAdImageStartLoad(ImageView adImage) {
    }

    protected void onTimeRefresh(Button continueBut, int remainSeconds) {
        if (this.showContinueBut) {
            if (!continueBut.isShown()) {
                continueBut.setVisibility(0);
            }
            continueBut.setText((CharSequence)String.format(this.getResources().getString(R.string.splash_continue), remainSeconds));
        }
    }

    protected void onAdImageClick(ImageView adImage) {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mActivity = this;
        this.getWindow().setFlags(1024, 1024);
        if (Build.VERSION.SDK_INT >= 19) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 6150;
            decorView.setSystemUiVisibility(6150);
        }
        this.setContentView(this.getLayoutResId());
        this.initUI();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.endTimer();
    }

    private void initUI() {
        this.timerHandler = new TimerHandler(this);
        this.timeOutHandler = new TimeOutHandler(this);
        this.adImage = (ImageView)this.findViewById(this.getAdImageResId());
        this.continueBut = (Button)this.findViewById(this.getContinueButResId());
        this.onAdImageStartLoad(this.adImage);
        this.timeOutHandler.sendEmptyMessage(1);
        this.adImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AbstractSplashActivity.this.adImage.getMeasuredHeight() > 0) {
                    AbstractSplashActivity.this.onAdImageClick(AbstractSplashActivity.this.adImage);
                }
            }
        });
        this.continueBut.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractSplashActivity.this.timerHandler.removeMessages(2);
                AbstractSplashActivity.this.timerHandler.sendEmptyMessage(3);
            }
        });
    }

    private static class TimeOutHandler
    extends Handler {
        private final WeakReference<AbstractSplashActivity> reference;

        public TimeOutHandler(AbstractSplashActivity ativity) {
            this.reference = new WeakReference<AbstractSplashActivity>(ativity);
        }

        public void handleMessage(Message msg) {
            AbstractSplashActivity activity = (AbstractSplashActivity)((Object)this.reference.get());
            if (activity == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    this.sendEmptyMessageDelayed(3, activity.maxSeconds * 1000);
                    break;
                }
                case 3: {
                    activity.onTimeEnd();
                }
            }
        }
    }

    private static class TimerHandler
    extends Handler {
        private final WeakReference<AbstractSplashActivity> reference;

        public TimerHandler(AbstractSplashActivity ativity) {
            this.reference = new WeakReference<AbstractSplashActivity>(ativity);
        }

        public void handleMessage(Message msg) {
            AbstractSplashActivity activity = (AbstractSplashActivity)((Object)this.reference.get());
            if (activity == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    activity.timeOutHandler.removeMessages(3);
                    activity.onTimeRefresh(activity.continueBut, activity.remainSeconds);
                    this.sendEmptyMessageDelayed(2, 1000L);
                    break;
                }
                case 2: {
                    --activity.remainSeconds;
                    if (activity.remainSeconds > 0) {
                        activity.onTimeRefresh(activity.continueBut, activity.remainSeconds);
                        this.sendEmptyMessageDelayed(2, 1000L);
                        break;
                    }
                    this.sendEmptyMessage(3);
                    break;
                }
                case 3: {
                    activity.onTimeEnd();
                }
            }
        }
    }
}

