/*
 * Decompiled with CFR 0.152.
 */
package com.wordplat.uikit.splash;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.wordplat.uikit.splash.R;

public abstract class AbstractWebViewActivity
extends Activity
implements View.OnClickListener {
    private RelativeLayout titleView;
    private ImageButton backBut;
    private ProgressBar progressBar;
    private WebView webView;
    private boolean isAnimStart = false;
    private int currentProgress;
    private boolean isGoBack = false;
    private static final String A = "a";
    private static final String B = "b";
    private static BackCallback backCallback;

    protected abstract int getBackButResId();

    protected abstract int getBackgroundColor();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_abstract_webview);
        this.initUI();
        this.setUpWebView();
    }

    private void initUI() {
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.titleView = (RelativeLayout)this.findViewById(R.id.titleView);
        this.backBut = (ImageButton)this.findViewById(R.id.backBut);
        TextView titleTextView = (TextView)this.findViewById(R.id.titleText);
        this.backBut.setImageResource(this.getBackButResId());
        this.titleView.setBackgroundColor(this.getBackgroundColor());
        String title = this.getIntent().getStringExtra(B);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            titleTextView.setText((CharSequence)title);
        } else {
            titleTextView.setText((CharSequence)"\u5e7f\u544a");
        }
        this.backBut.setOnClickListener((View.OnClickListener)this);
    }

    private void setUpWebView() {
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                if (!AbstractWebViewActivity.this.isGoBack) {
                    AbstractWebViewActivity.this.progressBar.setVisibility(0);
                    AbstractWebViewActivity.this.progressBar.setAlpha(1.0f);
                }
                AbstractWebViewActivity.this.isGoBack = false;
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                AbstractWebViewActivity.this.webView.loadUrl(url);
                return true;
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                AbstractWebViewActivity.this.currentProgress = AbstractWebViewActivity.this.progressBar.getProgress();
                if (newProgress >= 100 && !AbstractWebViewActivity.this.isAnimStart) {
                    AbstractWebViewActivity.this.isAnimStart = true;
                    AbstractWebViewActivity.this.progressBar.setProgress(newProgress);
                    AbstractWebViewActivity.this.startDismissAnimation(AbstractWebViewActivity.this.progressBar.getProgress());
                } else {
                    AbstractWebViewActivity.this.startProgressAnimation(newProgress);
                }
            }
        });
        this.webView.getSettings().setJavaScriptEnabled(true);
        String url = this.getIntent().getStringExtra(A);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.webView.loadUrl(url);
        }
    }

    private void startProgressAnimation(int newProgress) {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)this.progressBar, (String)"progress", (int[])new int[]{this.currentProgress, newProgress});
        animator.setDuration(300L);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.start();
    }

    private void startDismissAnimation(final int progress) {
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)this.progressBar, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        anim.setDuration(1500L);
        anim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float fraction = valueAnimator.getAnimatedFraction();
                int offset = 100 - progress;
                AbstractWebViewActivity.this.progressBar.setProgress((int)((float)progress + (float)offset * fraction));
            }
        });
        anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                AbstractWebViewActivity.this.progressBar.setProgress(0);
                AbstractWebViewActivity.this.progressBar.setVisibility(8);
                AbstractWebViewActivity.this.isAnimStart = false;
            }
        });
        anim.start();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.backBut) {
            this.onBackPressed();
        }
    }

    public void onBackPressed() {
        if (this.webView.canGoBack()) {
            this.isGoBack = true;
            this.webView.goBack();
            return;
        }
        super.onBackPressed();
        if (backCallback != null) {
            backCallback.onBackPressed();
        }
    }

    public static <E> Intent createIntent(Context context, Class<E> clz, String url) {
        Intent intent = new Intent(context, clz);
        intent.putExtra(A, url);
        return intent;
    }

    public static <E> Intent createIntent(Context context, Class<E> clz, String url, String title) {
        Intent intent = new Intent(context, clz);
        intent.putExtra(A, url);
        intent.putExtra(B, title);
        return intent;
    }

    public static void setBackCallback(BackCallback backCallback) {
        AbstractWebViewActivity.backCallback = backCallback;
    }

    public static interface BackCallback {
        public void onBackPressed();
    }
}

