/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swaggersocket.server;

import com.wordnik.swaggersocket.protocol.CloseMessage;
import com.wordnik.swaggersocket.protocol.HandshakeMessage;
import com.wordnik.swaggersocket.protocol.Header;
import com.wordnik.swaggersocket.protocol.Heartbeat;
import com.wordnik.swaggersocket.protocol.Message;
import com.wordnik.swaggersocket.protocol.ProtocolBase;
import com.wordnik.swaggersocket.protocol.QueryString;
import com.wordnik.swaggersocket.protocol.Request;
import com.wordnik.swaggersocket.protocol.Response;
import com.wordnik.swaggersocket.protocol.ResponseMessage;
import com.wordnik.swaggersocket.protocol.StatusMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereInterceptorService
public class SwaggerSocketProtocolInterceptor
extends AtmosphereInterceptorAdapter {
    private static final String SWAGGER_SOCKET_DISPATCHED = "request.dispatched";
    private static final String IDENTITY = "swaggersocket.identity";
    private static final String RESPONSE_COUNTER = "-ResponseCountNumber";
    private static final String SUSPENDED_RESPONSE = "-PendingResource";
    private static final Logger logger = LoggerFactory.getLogger(SwaggerSocketProtocolInterceptor.class);
    private final ObjectMapper mapper;
    private boolean delegateHandshake = false;
    private final AsyncIOInterceptor interceptor = new Interceptor();
    private final ThreadLocal<Request> ssRequest = new ThreadLocal();
    private final ThreadLocal<String> transactionIdentity = new ThreadLocal();
    private final Broadcaster heartbeat;

    public SwaggerSocketProtocolInterceptor() {
        this.mapper = new ObjectMapper();
        this.heartbeat = BroadcasterFactory.getDefault().get(DefaultBroadcaster.class, (Object)"/swaggersocket.heatbeat");
    }

    public void configure(AtmosphereConfig config) {
    }

    public Action inspect(final AtmosphereResource r) {
        AtmosphereRequest request = r.getRequest();
        r.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

            public void onSuspend(AtmosphereResourceEvent event) {
                AsyncIOWriter writer = event.getResource().getResponse().getAsyncIOWriter();
                if (writer == null) {
                    writer = new AtmosphereInterceptorWriter();
                    r.getResponse().asyncIOWriter(writer);
                }
                if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                    ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(SwaggerSocketProtocolInterceptor.this.interceptor);
                }
            }
        });
        boolean ok = false;
        if (request.getHeader("SwaggerSocket") != null) {
            ok = true;
        }
        if (ok && request.getAttribute(SWAGGER_SOCKET_DISPATCHED) == null) {
            AtmosphereResponse response = r.getResponse();
            response.setContentType("application/json");
            logger.debug("Method {} Transport {}", (Object)request.getMethod(), (Object)r.transport());
            if (request.getMethod() == "GET" && r.transport().equals((Object)AtmosphereResource.TRANSPORT.LONG_POLLING)) {
                r.resumeOnBroadcast(true).suspend();
                LinkedBlockingQueue<AtmosphereResource> queue = (LinkedBlockingQueue<AtmosphereResource>)this.getContextValue(request, SUSPENDED_RESPONSE);
                if (queue == null) {
                    queue = new LinkedBlockingQueue<AtmosphereResource>();
                    request.getSession().setAttribute(SUSPENDED_RESPONSE, queue);
                }
                queue.offer(r);
                String identity = (String)this.getContextValue(request, IDENTITY);
                this.schedule(r, identity);
                return Action.SUSPEND;
            }
            AtmosphereFramework framework = r.getAtmosphereConfig().framework();
            StringBuilder d = new StringBuilder();
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)request.getInputStream());
                BufferedReader bufReader = new BufferedReader(isr);
                char[] charBuffer = new char[8192];
                int readCount = bufReader.read(charBuffer);
                while (readCount > -1) {
                    d.append(charBuffer, 0, readCount);
                    readCount = bufReader.read(charBuffer);
                }
                String data = d.toString();
                if (data.length() == 0) {
                    return Action.CANCELLED;
                }
                String message = data.substring(0, 20).replaceAll(" ", "");
                logger.debug(data);
                if (message.startsWith("{\"handshake\"")) {
                    HandshakeMessage handshakeMessage = (HandshakeMessage)this.mapper.readValue(data, HandshakeMessage.class);
                    String identity = (String)this.getContextValue(request, IDENTITY);
                    if (identity == null) {
                        identity = UUID.randomUUID().toString();
                    } else {
                        logger.debug("Client disconnected {}, cleaning session {}", (Object)identity);
                        try {
                            Enumeration e = request.getSession().getAttributeNames();
                            while (e.hasMoreElements()) {
                                request.getSession().removeAttribute((String)e.nextElement());
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("", (Throwable)ex);
                        }
                    }
                    this.addContextValue(request, IDENTITY, identity);
                    StatusMessage statusMessage = new StatusMessage.Builder().status(new StatusMessage.Status(200, "OK")).identity(identity).build();
                    response.setContentType("application/json");
                    response.getOutputStream().write(this.mapper.writeValueAsBytes((Object)statusMessage));
                    if (r.transport() == AtmosphereResource.TRANSPORT.WEBSOCKET) {
                        this.schedule(r, identity);
                    }
                    if (!this.delegateHandshake) {
                        return Action.CANCELLED;
                    }
                } else {
                    if (message.startsWith("{\"close\"")) {
                        CloseMessage c = (CloseMessage)this.mapper.readValue(data, CloseMessage.class);
                        logger.debug("Client disconnected {} with reason {}", (Object)c.getClose().getIdentity(), (Object)c.getClose().getReason());
                        try {
                            request.getSession().invalidate();
                        }
                        catch (Exception ex) {
                            logger.warn("", (Throwable)ex);
                        }
                        return Action.CANCELLED;
                    }
                    Message swaggerSocketMessage = (Message)this.mapper.readValue(data, Message.class);
                    swaggerSocketMessage.transactionID(UUID.randomUUID().toString());
                    String identity = (String)this.getContextValue(request, IDENTITY);
                    if (!swaggerSocketMessage.getIdentity().equals(identity)) {
                        StatusMessage statusMessage = new StatusMessage.Builder().status(new StatusMessage.Status(503, "Not Allowed")).identity(swaggerSocketMessage.getIdentity()).build();
                        response.getOutputStream().write(this.mapper.writeValueAsBytes((Object)statusMessage));
                        return Action.CANCELLED;
                    }
                    this.transactionIdentity.set(swaggerSocketMessage.transactionID());
                    List requests = swaggerSocketMessage.getRequests();
                    this.addContextValue(request, swaggerSocketMessage.transactionID() + RESPONSE_COUNTER, new AtomicInteger(requests.size()));
                    for (Request req : requests) {
                        AtmosphereRequest ar = SwaggerSocketProtocolInterceptor.toAtmosphereRequest(request, (ProtocolBase)req);
                        try {
                            ar.setAttribute(SWAGGER_SOCKET_DISPATCHED, (Object)"true");
                            request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
                            response.request(ar);
                            this.attachWriter(r);
                            this.ssRequest.set(req);
                            request.setAttribute("swaggerSocketRequest", (Object)req);
                            Action action = framework.doCometSupport(ar, response);
                            if (action.type() != Action.TYPE.SUSPEND) continue;
                            ar.destroyable(false);
                            response.destroyable(false);
                        }
                        catch (ServletException e) {
                            logger.warn("", (Throwable)e);
                            return Action.CANCELLED;
                        }
                    }
                }
                return Action.CANCELLED;
            }
            catch (IOException e) {
                logger.warn("", (Throwable)e);
                return Action.CONTINUE;
            }
        }
        request.setAttribute(SWAGGER_SOCKET_DISPATCHED, null);
        if (!ok) {
            request.setAttribute(TrackMessageSizeInterceptor.SKIP_INTERCEPTOR, (Object)"true");
        }
        return Action.CONTINUE;
    }

    private final void attachWriter(AtmosphereResource r) {
        final AtmosphereRequest request = r.getRequest();
        AtmosphereResponse res = r.getResponse();
        Object writer = res.getAsyncIOWriter();
        LinkedBlockingQueue queue = (LinkedBlockingQueue)this.getContextValue(request, SUSPENDED_RESPONSE);
        if (queue == null) {
            queue = new LinkedBlockingQueue();
            request.getSession().setAttribute(SUSPENDED_RESPONSE, queue);
        }
        if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
            if (r.transport() != AtmosphereResource.TRANSPORT.WEBSOCKET) {
                writer = new AtmosphereInterceptorWriter(){

                    protected void writeReady(AtmosphereResponse response, byte[] data) throws IOException {
                        if (data == null) {
                            return;
                        }
                        BlockingQueue queue = (BlockingQueue)SwaggerSocketProtocolInterceptor.this.getContextValue(request, SwaggerSocketProtocolInterceptor.SUSPENDED_RESPONSE);
                        if (queue != null) {
                            AtmosphereResource resource;
                            try {
                                resource = (AtmosphereResource)queue.poll(60L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                logger.trace("", (Throwable)e);
                                return;
                            }
                            if (resource == null) {
                                logger.debug("No resource was suspended, resuming the second connection.");
                            } else {
                                logger.trace("Resuming {}", (Object)resource.uuid());
                                try {
                                    ServletOutputStream o = resource.getResponse().getResponse().getOutputStream();
                                    o.write(data);
                                    o.flush();
                                    resource.resume();
                                }
                                catch (IOException ex) {
                                    logger.warn("", (Throwable)ex);
                                }
                            }
                        } else {
                            logger.error("Queue was null");
                        }
                    }

                    public AtmosphereInterceptorWriter interceptor(AsyncIOInterceptor filter) {
                        if (!this.filters.contains(filter)) {
                            this.filters.addLast(filter);
                        }
                        return this;
                    }
                };
                res.asyncIOWriter(writer);
            }
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(this.interceptor);
        }
    }

    protected void schedule(AtmosphereResource r, String uuid) {
        this.heartbeat.addAtmosphereResource(r).scheduleFixedBroadcast((Object)("heartbeat-" + uuid), 60L, 60L, TimeUnit.SECONDS);
    }

    protected static final AtmosphereRequest toAtmosphereRequest(AtmosphereRequest r, ProtocolBase request) {
        AtmosphereRequest.Builder b = new AtmosphereRequest.Builder();
        if (request.getHeaders() != null) {
            for (Header h : request.getHeaders()) {
                r.header(h.getName(), h.getValue());
            }
        }
        HashMap<String, String[]> queryStrings = new HashMap<String, String[]>();
        if (request.getQueryString() != null) {
            for (QueryString h : request.getQueryString()) {
                String[] s = (String[])queryStrings.get(h.getName());
                if (s != null) {
                    String[] s1 = new String[s.length];
                    System.arraycopy(s, 0, s1, 0, s.length);
                    s1[s.length] = h.getValue();
                    queryStrings.put(h.getName(), s1);
                    continue;
                }
                queryStrings.put(h.getName(), new String[]{h.getValue()});
            }
        }
        String p = request.getPath().replaceAll("\\s+", "%20").trim();
        String requestURL = r.getRequestURL() + p;
        if (r.getRequestURL().toString().endsWith("/") && p.startsWith("/")) {
            requestURL = r.getRequestURL().toString() + p.substring(1);
        }
        String requestURI = r.getRequestURI() + p;
        if (r.getRequestURI().endsWith("/") && p.startsWith("/")) {
            requestURI = r.getRequestURI() + p.substring(1);
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        b.pathInfo(p).contentType(request.getDataFormat()).method(request.getMethod()).queryStrings(queryStrings).requestURI(requestURI).requestURL(requestURL).request((HttpServletRequest)r).body(request.getMessageBody().toString());
        return b.build();
    }

    private final void addContextValue(AtmosphereRequest request, String name, Object value) {
        if (request.resource().transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
            request.setAttribute(name, value);
        } else {
            request.getSession().setAttribute(name, value);
        }
    }

    private final Object getContextValue(AtmosphereRequest request, String name) {
        if (request.resource().transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
            return request.getAttribute(name);
        }
        return request.getSession().getAttribute(name);
    }

    protected Request lookupRequest(AtmosphereRequest request) {
        Request swaggerSocketRequest = this.ssRequest.get();
        if (swaggerSocketRequest == null) {
            swaggerSocketRequest = (Request)request.getAttribute("swaggerSocketRequest");
        }
        return swaggerSocketRequest;
    }

    protected final Object wrapMessage(AtmosphereResponse res, String message) {
        if (message != null && message.startsWith("heartbeat-")) {
            String identity = (String)this.getContextValue(res.request(), IDENTITY);
            return new Heartbeat(String.valueOf(System.nanoTime()), identity);
        }
        Request swaggerSocketRequest = this.lookupRequest(res.request());
        Response.Builder builder = new Response.Builder();
        builder.body((Object)message).status(res.getStatus(), res.getStatusMessage());
        Map headers = res.headers();
        for (String s : headers.keySet()) {
            builder.header(new Header(s, (String)headers.get(s)));
        }
        builder.uuid(swaggerSocketRequest.getUuid()).method(swaggerSocketRequest.getMethod()).path(swaggerSocketRequest.getPath());
        String identity = (String)this.getContextValue(res.request(), IDENTITY);
        AtomicInteger expectedResponseCount = (AtomicInteger)this.getContextValue(res.request(), this.transactionIdentity.get() + RESPONSE_COUNTER);
        ResponseMessage m = null;
        if (expectedResponseCount != null && res.resource().transport() != AtmosphereResource.TRANSPORT.WEBSOCKET) {
            m = (ResponseMessage)this.getContextValue(res.request(), this.transactionIdentity.get() + ResponseMessage.class.getName());
            if (m != null) {
                m.response(builder.build());
            } else {
                m = new ResponseMessage(identity, builder.build());
            }
            if (expectedResponseCount.decrementAndGet() <= 0) {
                return m;
            }
            this.addContextValue(res.request(), this.transactionIdentity.get() + ResponseMessage.class.getName(), m);
            return null;
        }
        if (m == null) {
            m = new ResponseMessage(identity, builder.build());
        }
        return m;
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            Object rm = SwaggerSocketProtocolInterceptor.this.wrapMessage(response, new String(responseDraft, response.getCharacterEncoding()));
            if (rm != null) {
                return SwaggerSocketProtocolInterceptor.this.mapper.writeValueAsBytes(rm);
            }
            return null;
        }

        public byte[] error(AtmosphereResponse response, int statusCode, String reasonPhrase) {
            Request swaggerSocketRequest = SwaggerSocketProtocolInterceptor.this.lookupRequest(response.request());
            if (swaggerSocketRequest == null) {
                logger.debug("Handshake mapping (could be expected) {} : {}", (Object)response.getStatus(), (Object)response.getStatusMessage());
                return new byte[0];
            }
            logger.debug("Unexpected status code {} : {}", (Object)response.getStatus(), (Object)response.getStatusMessage());
            StatusMessage statusMessage = new StatusMessage.Builder().status(new StatusMessage.Status(response.getStatus(), response.getStatusMessage())).identity(swaggerSocketRequest.getUuid()).build();
            try {
                return SwaggerSocketProtocolInterceptor.this.mapper.writeValueAsBytes((Object)statusMessage);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

