package com.wms.network.common;

import com.trello.rxlifecycle3.android.ActivityEvent;
import com.wms.network.baseserver.BaseHttpResult;
import com.wms.network.callback.NetCallback;

import io.reactivex.Observable;
import io.reactivex.subjects.BehaviorSubject;

/**
 * Created by 王梦思 on 2019/4/13.
 * <p/>
 */
public interface IHttpRequestExecutor {
    <T> void execute(Observable<? extends BaseHttpResult<T>> observable, BehaviorSubject<ActivityEvent> lifecycle, NetCallback<T> callback);

    /**
     * 执行retrofit请求
     *
     * @param observable 具体的请求
     * @param callback   回调
     * @param <T>        返回的数据类型
     */
    <T> void execute(Observable<? extends BaseHttpResult<T>> observable, NetCallback<T> callback);

    <T> void executeRawData(Observable<T> observable, BehaviorSubject<ActivityEvent> lifecycle, NetCallback<T> callback);

    /**
     * 执行retrofit请求获取原始数据
     *
     * @param observable 具体的请求
     * @param callback   回调
     * @param <T>        返回的数据类型
     */
    <T> void executeRawData(Observable<T> observable, NetCallback<T> callback);
}
