package com.wms.network.callback;

/**
 * Created by 王梦思 on 2018/9/23.
 * <p/>
 */
public class NetCallbackAdapter<T> extends NetCallback<T> {

    private NetCallback<T> callback;

    public NetCallbackAdapter(NetCallback callback) {
        this.callback = callback;
    }

    @Override
    public void onStart() {
        if (callback != null) {
            callback.onStart();
        }
    }

    @Override
    public void onNoNet() {
        if (callback != null) {
            callback.onNoNet();
        }
    }

    @Override
    public void onSucceed(T data) {
        if (callback != null) {
            callback.onSucceed(data);
        }
    }

    @Override
    public void onFailed(String msg) {
        if (callback != null) {
            callback.onFailed(msg);
        }
    }

    @Override
    public void onComplete() {
        if (callback != null) {
            callback.onComplete();
        }
    }
}
