package com.wms.network.baseserver;

import com.google.gson.annotations.SerializedName;

/**
 * Created by 王梦思 on 2019/4/11.
 * <p/>
 */
public class HttpResult<T> extends BaseHttpResult<T> {

    /**
     * 错误码
     */
    @SerializedName(value = "code", alternate = {"status"})
    private int code;
    /**
     * 错误消息
     */
    @SerializedName(value = "msg", alternate = {"message"})
    private String msg;
    /**
     * 请求成功后的json对象
     */
    @SerializedName(value = "data", alternate = {"datas"})
    private T data;

    @Override
    public boolean isSuccess() {
        return code == 0;
    }

    @Override
    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
